/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util.simple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectUtils {
    public static boolean nullSafeClassEquals(Object object1, Object object2) {
        if (object1 == null || object2 == null) {
            return false;
        }
        return object1.getClass() == object2.getClass();
    }

    public static int nullSafeHashCode(Object toHash) {
        if (toHash == null) {
            return 0;
        }
        if (toHash.getClass().isArray()) {
            return ObjectUtils.deepHashCode((Object[])toHash);
        }
        return toHash.hashCode();
    }

    public static boolean nullSafeEquals(Object object1, Object object2) {
        if (object1 == null) {
            return object2 == null;
        }
        if (object1.getClass().isArray()) {
            if (object2 == null || !object2.getClass().isArray()) {
                return false;
            }
            return ObjectUtils.deepEquals((Object[])object1, (Object[])object2);
        }
        return object1.equals(object2);
    }

    public static <T> int nullSafeCompareTo(Comparable<T> object1, T object2) {
        if (object1 == null) {
            if (object2 == null) {
                return 0;
            }
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        return object1.compareTo(object2);
    }

    private static int deepHashCode(Object[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (Object element : a) {
            int elementHash = 0;
            if (element instanceof Object[]) {
                elementHash = ObjectUtils.deepHashCode((Object[])element);
            } else if (element != null) {
                elementHash = element.hashCode();
            }
            result = 31 * result + elementHash;
        }
        return result;
    }

    private static boolean deepEquals(Object[] a1, Object[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        int length = a1.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Object e1 = a1[i];
            Object e2 = a2[i];
            if (e1 == e2) continue;
            if (e1 == null) {
                return false;
            }
            boolean eq = e1 instanceof Object[] && e2 instanceof Object[] ? ObjectUtils.deepEquals((Object[])e1, (Object[])e2) : e1.equals(e2);
            if (eq) continue;
            return false;
        }
        return true;
    }

    private ObjectUtils() {
    }
}

