/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.vaadin.ui.widgetprocessor.binding.simple;

import com.vaadin.data.Property;
import com.vaadin.ui.Component;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.vaadin.ui.VaadinMetawidget;
import org.metawidget.vaadin.ui.widgetprocessor.binding.BindingConverter;
import org.metawidget.vaadin.ui.widgetprocessor.binding.simple.ConvertFromTo;
import org.metawidget.vaadin.ui.widgetprocessor.binding.simple.Converter;
import org.metawidget.vaadin.ui.widgetprocessor.binding.simple.FromStringConverter;
import org.metawidget.vaadin.ui.widgetprocessor.binding.simple.NumberConverter;
import org.metawidget.vaadin.ui.widgetprocessor.binding.simple.SimpleBindingProcessorConfig;
import org.metawidget.vaadin.ui.widgetprocessor.binding.simple.ToStringConverter;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBindingProcessor
implements AdvancedWidgetProcessor<Component, VaadinMetawidget>,
BindingConverter {
    private final Map<ConvertFromTo, Converter<?, ?>> mConverters = CollectionUtils.newHashMap();

    public SimpleBindingProcessor() {
        this(new SimpleBindingProcessorConfig());
    }

    public SimpleBindingProcessor(SimpleBindingProcessorConfig config) {
        this.mConverters.put(new ConvertFromTo(String.class, Object.class), new FromStringConverter());
        this.mConverters.put(new ConvertFromTo(Object.class, String.class), new ToStringConverter());
        this.mConverters.put(new ConvertFromTo(Number.class, Number.class), new NumberConverter());
        if (config.getConverters() != null) {
            this.mConverters.putAll(config.getConverters());
        }
    }

    @Override
    public void onStartBuild(VaadinMetawidget metawidget) {
        metawidget.putClientProperty(SimpleBindingProcessor.class, null);
    }

    @Override
    public Component processWidget(Component component, String elementName, Map<String, String> attributes, VaadinMetawidget metawidget) {
        String[] names;
        if (component instanceof VaadinMetawidget) {
            State state = this.getState(metawidget);
            if (state.nestedMetawidgets == null) {
                state.nestedMetawidgets = new HashSet<VaadinMetawidget>();
            }
            state.nestedMetawidgets.add((VaadinMetawidget)component);
            return component;
        }
        if (!(component instanceof Property)) {
            return component;
        }
        if ("true".equals(attributes.get("no-getter"))) {
            return component;
        }
        String type = attributes.get("type");
        if (type == null) {
            return component;
        }
        Class<?> toInspectPropertyType = ClassUtils.niceForName(type);
        Object value = metawidget.getToInspect();
        if (value == null) {
            return component;
        }
        String path = metawidget.getPath();
        if ("property".equals(elementName) || "action".equals(elementName)) {
            path = path + '/' + attributes.get("name");
        }
        for (String name : names = PathUtils.parsePath(path).getNamesAsArray()) {
            value = ClassUtils.getProperty(value, name);
        }
        try {
            boolean readOnly;
            Property property = (Property)component;
            Class componentPropertyType = property.getType();
            Converter setValueConverter = this.getConverter(toInspectPropertyType, componentPropertyType);
            if (setValueConverter != null) {
                value = setValueConverter.convert(value, componentPropertyType);
            }
            if (readOnly = property.isReadOnly()) {
                property.setReadOnly(false);
            }
            property.setValue(value);
            if (readOnly) {
                property.setReadOnly(true);
            }
            if (WidgetBuilderUtils.isReadOnly(attributes)) {
                return component;
            }
            State state = this.getState(metawidget);
            if (state.bindings == null) {
                state.bindings = new HashSet<Object[]>();
            }
            state.bindings.add(new Object[]{property, names, toInspectPropertyType});
        }
        catch (Exception e) {
            throw WidgetProcessorException.newException(e);
        }
        return component;
    }

    public void save(VaadinMetawidget metawidget) {
        State state = this.getState(metawidget);
        if (state.bindings != null) {
            Object toSave = metawidget.getToInspect();
            if (toSave == null) {
                return;
            }
            for (Object[] binding : state.bindings) {
                Property property = (Property)binding[0];
                String[] names = (String[])binding[1];
                Class toInspectPropertyType = (Class)binding[2];
                Object value = property.getValue();
                Converter getValueConverter = this.getConverter(property.getType(), toInspectPropertyType);
                if (getValueConverter != null) {
                    value = getValueConverter.convert(value, toInspectPropertyType);
                }
                Object parent = toSave;
                int length = names.length;
                for (int loop = 0; loop < length - 1; ++loop) {
                    if ((parent = ClassUtils.getProperty(parent, names[loop])) != null) continue;
                    return;
                }
                ClassUtils.setProperty(parent, names[length - 1], value);
            }
        }
        if (state.nestedMetawidgets != null) {
            for (VaadinMetawidget nestedmetawidget : state.nestedMetawidgets) {
                this.save(nestedmetawidget);
            }
        }
    }

    @Override
    public void onEndBuild(VaadinMetawidget metawidget) {
    }

    @Override
    public Object convertFromString(String value, Class<?> expectedType) {
        Converter<String, ?> converterFromString = this.getConverter(String.class, expectedType);
        if (converterFromString != null) {
            return converterFromString.convert(value, expectedType);
        }
        return value;
    }

    State getState(VaadinMetawidget metawidget) {
        State state = (State)metawidget.getClientProperty(SimpleBindingProcessor.class);
        if (state == null) {
            state = new State();
            metawidget.putClientProperty(SimpleBindingProcessor.class, state);
        }
        return state;
    }

    private <F, T> Converter<F, T> getConverter(Class<F> sourceClass, Class<T> targetClass) {
        Class<Object> targetClassTraversal = targetClass;
        if (targetClassTraversal.isPrimitive()) {
            targetClassTraversal = ClassUtils.getWrapperClass(targetClassTraversal);
        }
        while (targetClassTraversal != null) {
            Class<Object> sourceClassTraversal = sourceClass;
            if (sourceClassTraversal.isPrimitive()) {
                sourceClassTraversal = ClassUtils.getWrapperClass(sourceClassTraversal);
            }
            while (sourceClassTraversal != null) {
                Converter<?, ?> converter = this.mConverters.get(new ConvertFromTo(sourceClassTraversal, targetClassTraversal));
                if (converter != null) {
                    return converter;
                }
                sourceClassTraversal = sourceClassTraversal.getSuperclass();
            }
            targetClassTraversal = targetClassTraversal.getSuperclass();
        }
        return null;
    }

    static class State {
        Set<Object[]> bindings;
        Set<VaadinMetawidget> nestedMetawidgets;

        State() {
        }
    }
}

