/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.decoders;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataDecoder;
import org.milyn.javabean.DecodeType;
import org.milyn.javabean.decoders.LocaleAwareDateDecoder;

@DecodeType(value={Calendar.class})
public class CalendarDecoder
extends LocaleAwareDateDecoder
implements DataDecoder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object decode(String data) throws DataDecodeException {
        if (this.decoder == null) {
            throw new IllegalStateException("Calendar decoder not initialised.  A decoder for this type (" + this.getClass().getName() + ") must be explicitly configured (unlike the primitive type decoders) with a date 'format'. See Javadoc.");
        }
        try {
            SimpleDateFormat simpleDateFormat = this.decoder;
            synchronized (simpleDateFormat) {
                this.decoder.parse(data.trim());
                return this.decoder.getCalendar().clone();
            }
        }
        catch (ParseException e) {
            throw new DataDecodeException("Error decoding Date data value '" + data + "' with decode format '" + this.format + "'.", e);
        }
    }
}

