/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.pojogen;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import org.milyn.assertion.AssertArgument;
import org.milyn.io.StreamUtils;
import org.milyn.javabean.pojogen.JMethod;
import org.milyn.javabean.pojogen.JNamedType;
import org.milyn.javabean.pojogen.JType;
import org.milyn.javabean.pojogen.PojoGenUtil;
import org.milyn.util.FreeMarkerTemplate;

public class JClass {
    private String uniqueId;
    private String packageName;
    private String className;
    private Set<JType> rawImports = new LinkedHashSet<JType>();
    private Set<JType> implementTypes = new LinkedHashSet<JType>();
    private Set<JType> extendTypes = new LinkedHashSet<JType>();
    private Set<JType> annotationTypes = new LinkedHashSet<JType>();
    private Class<?> skeletonClass;
    private List<JNamedType> properties = new ArrayList<JNamedType>();
    private List<JMethod> constructors = new ArrayList<JMethod>();
    private List<JMethod> methods = new ArrayList<JMethod>();
    private boolean fluentSetters = true;
    private boolean serializable = false;
    private boolean finalized = false;
    private static FreeMarkerTemplate template;

    public JClass(String packageName, String className) {
        this(packageName, className, UUID.randomUUID().toString());
    }

    public JClass(String packageName, String className, String uniqueId) {
        AssertArgument.isNotNull(packageName, "packageName");
        AssertArgument.isNotNull(className, "className");
        AssertArgument.isNotNull(uniqueId, "uniqueId");
        this.packageName = packageName;
        this.className = className;
        this.uniqueId = uniqueId;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public Set<JType> getRawImports() {
        return this.rawImports;
    }

    public Set<JType> getImplementTypes() {
        return this.implementTypes;
    }

    public Set<JType> getExtendTypes() {
        return this.extendTypes;
    }

    public Set<JType> getAnnotationTypes() {
        return this.annotationTypes;
    }

    public void setFluentSetters(boolean fluentSetters) {
        this.fluentSetters = fluentSetters;
    }

    public Class<?> getSkeletonClass() {
        if (this.skeletonClass == null) {
            String skeletonClassName = this.packageName + "." + this.className;
            try {
                this.skeletonClass = Thread.currentThread().getContextClassLoader().loadClass(skeletonClassName);
            }
            catch (ClassNotFoundException e) {
                ClassPool pool = new ClassPool(true);
                CtClass cc = pool.makeClass(skeletonClassName);
                try {
                    this.skeletonClass = cc.toClass();
                }
                catch (CannotCompileException ee) {
                    throw new IllegalStateException("Unable to create runtime skeleton class for class '" + skeletonClassName + "'.", ee);
                }
                finally {
                    cc.detach();
                }
            }
        }
        return this.skeletonClass;
    }

    public JClass setSerializable() {
        this.serializable = true;
        this.implementTypes.add(new JType(Serializable.class));
        return this;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public void addProperty(JNamedType property) {
        AssertArgument.isNotNull(property, "property");
        this.assertPropertyUndefined(property);
        this.properties.add(property);
    }

    public JClass addBeanProperty(JNamedType property) {
        this.addProperty(property);
        String propertyName = property.getName();
        String capitalizedPropertyName = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        JMethod getterMethod = new JMethod(property.getType(), "get" + capitalizedPropertyName);
        getterMethod.appendToBody("return " + property.getName() + ";");
        this.methods.add(getterMethod);
        if (this.fluentSetters) {
            JMethod setterMethod = new JMethod(new JType(this.getSkeletonClass()), "set" + capitalizedPropertyName);
            setterMethod.addParameter(property);
            setterMethod.appendToBody("this." + property.getName() + " = " + property.getName() + ";  return this;");
            this.methods.add(setterMethod);
        } else {
            JMethod setterMethod = new JMethod("set" + capitalizedPropertyName);
            setterMethod.addParameter(property);
            setterMethod.appendToBody("this." + property.getName() + " = " + property.getName() + ";");
            this.methods.add(setterMethod);
        }
        return this;
    }

    public List<JNamedType> getProperties() {
        return this.properties;
    }

    public List<JMethod> getConstructors() {
        return this.constructors;
    }

    public List<JMethod> getMethods() {
        return this.methods;
    }

    public JMethod getDefaultConstructor() {
        for (JMethod constructor : this.constructors) {
            if (!constructor.getParameters().isEmpty()) continue;
            return constructor;
        }
        JMethod constructor = new JMethod(this.getClassName());
        this.constructors.add(constructor);
        return constructor;
    }

    public Set<Class<?>> getImports() {
        LinkedHashSet importSet = new LinkedHashSet();
        this.addImports(importSet, this.implementTypes);
        this.addImports(importSet, this.extendTypes);
        this.addImports(importSet, this.annotationTypes);
        for (JNamedType property : this.properties) {
            property.getType().addImports(importSet, new String[]{"java.lang", this.packageName});
        }
        this.addMethodImportData(this.constructors, importSet);
        this.addMethodImportData(this.methods, importSet);
        this.addImports(importSet, this.rawImports);
        return importSet;
    }

    private void addImports(Set<Class<?>> importSet, Collection<JType> types) {
        for (JType property : types) {
            property.addImports(importSet, new String[]{"java.lang", this.packageName});
        }
    }

    private void addMethodImportData(List<JMethod> methodList, Set<Class<?>> importSet) {
        for (JMethod method : methodList) {
            method.getReturnType().addImports(importSet, new String[]{"java.lang", this.packageName});
            for (JNamedType param : method.getParameters()) {
                param.getType().addImports(importSet, new String[]{"java.lang", this.packageName});
            }
            for (JType exception : method.getExceptions()) {
                exception.addImports(importSet, new String[]{"java.lang", this.packageName});
            }
        }
    }

    public String getImplementsDecl() {
        return PojoGenUtil.getTypeDecl("implements", this.implementTypes);
    }

    public String getExtendsDecl() {
        return PojoGenUtil.getTypeDecl("extends", this.extendTypes);
    }

    public void writeClass(Writer writer) throws IOException {
        HashMap<String, JClass> contextObj = new HashMap<String, JClass>();
        contextObj.put("class", this);
        writer.write(template.apply(contextObj));
        this.finalizeMethods(this.constructors);
        this.finalizeMethods(this.methods);
        this.finalized = true;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    private void finalizeMethods(List<JMethod> methodList) {
        for (JMethod method : methodList) {
            method.finalizeMethod();
        }
    }

    private void assertPropertyUndefined(JNamedType property) {
        if (this.hasProperty(property.getName())) {
            throw new IllegalArgumentException("Property '" + property.getName() + "' already defined.");
        }
    }

    public boolean hasProperty(String propertyName) {
        for (JNamedType definedProperty : this.properties) {
            if (!definedProperty.getName().equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            template = new FreeMarkerTemplate(StreamUtils.readStreamAsString(JClass.class.getResourceAsStream("JavaClass.ftl")));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load JavaClass.ftl FreeMarker template.", e);
        }
    }
}

