/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.pojogen;

import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.milyn.assertion.AssertArgument;

public class JType {
    private Class<?> type;
    private Class<?> genericType;

    public JType(Class<?> type) {
        AssertArgument.isNotNull(type, "type");
        this.type = type;
    }

    public JType(Class<?> type, Class<?> genericType) {
        AssertArgument.isNotNull(type, "type");
        AssertArgument.isNotNull(genericType, "genericType");
        this.type = type;
        this.genericType = genericType;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?> getGenericType() {
        return this.genericType;
    }

    public void addImports(Set<Class<?>> importSet, String[] excludePackages) {
        AssertArgument.isNotNull(importSet, "importSet");
        if (!this.type.isPrimitive() && !ArrayUtils.contains((Object[])excludePackages, (Object)this.getPackageName(this.type))) {
            importSet.add(this.type);
        }
        if (this.genericType != null && !this.genericType.isPrimitive() && !ArrayUtils.contains((Object[])excludePackages, (Object)this.getPackageName(this.genericType))) {
            importSet.add(this.genericType);
        }
    }

    private String getPackageName(Class clazz) {
        String name = clazz.getName();
        int lastDot = name.lastIndexOf(46);
        return name.substring(0, lastDot);
    }

    public String toString() {
        if (this.genericType != null) {
            return this.type.getSimpleName() + "<" + this.genericType.getSimpleName() + ">";
        }
        return this.type.getSimpleName();
    }

    public boolean equals(Object obj) {
        JType typeObj;
        if (obj instanceof JType && (typeObj = (JType)obj).getType().getName().equals(this.type.getName())) {
            return this.genericType == null || typeObj.genericType == null || typeObj.genericType.getName().equals(this.genericType.getName());
        }
        return false;
    }

    public int hashCode() {
        if (this.genericType != null) {
            return this.type.getName().hashCode() + this.genericType.getName().hashCode();
        }
        return this.type.getName().hashCode();
    }
}

