/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.servlet.ServletConfig;
import org.milyn.resource.ContainerResourceLocator;
import org.milyn.resource.ExternalResourceLocator;
import org.milyn.servlet.ServletParamUtils;

public class ServletResourceLocator
implements ContainerResourceLocator {
    private ServletConfig config = null;
    private ExternalResourceLocator externalResourceLocator = null;

    public ServletResourceLocator(ServletConfig config, ExternalResourceLocator externalResourceLocator) {
        if (config == null) {
            throw new IllegalArgumentException("null 'config' paramater in method call.");
        }
        this.config = config;
        this.externalResourceLocator = externalResourceLocator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InputStream getResource(String configName, String defaultUri) throws IllegalArgumentException, IOException {
        if (defaultUri != null && defaultUri.trim().equals("")) {
            throw new IllegalArgumentException("empty 'defaultUri' paramater in method call.");
        }
        String configVal = ServletParamUtils.getParameterValue(configName, this.config);
        if (configVal == null) {
            if (defaultUri == null) throw new IllegalArgumentException("Resource [" + configName + "] not specified in configuration, plus no default load location provided.");
            this.config.getServletContext().log("[Milyn] Defaulting resource [" + configName + "] load location to: " + defaultUri);
            configVal = defaultUri;
        } else {
            this.config.getServletContext().log("[Milyn] Resource [" + configName + "] load location[servlet-context]: " + configVal);
        }
        InputStream resourceStream = this.getResource(configVal);
        if (resourceStream != null) return resourceStream;
        if (configVal != defaultUri) throw new IllegalArgumentException("Invalid resource parameter [" + configName + "=" + configVal + "] defined in deployment descriptor.  Unable to access specified resource.");
        throw new IOException("Unable to access default [" + configName + "] resource: " + defaultUri);
    }

    @Override
    public InputStream getResource(String uri) throws IllegalArgumentException, IOException {
        InputStream resourceStream = this.config.getServletContext().getResourceAsStream(uri);
        if (resourceStream == null) {
            resourceStream = this.config.getServletContext().getResourceAsStream("/WEB-INF" + uri);
        }
        if (resourceStream == null && this.externalResourceLocator != null) {
            resourceStream = this.externalResourceLocator.getResource(uri);
        }
        return resourceStream;
    }

    @Override
    public URI getBaseURI() {
        return URI.create(this.config.getServletContext().getContextPath());
    }
}

