/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.calc;

import java.io.IOException;
import java.util.Set;
import org.milyn.SmooksException;
import org.milyn.calc.CountDirection;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.Fragment;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.annotation.VisitAfterIf;
import org.milyn.delivery.annotation.VisitBeforeIf;
import org.milyn.delivery.dom.DOMVisitAfter;
import org.milyn.delivery.dom.DOMVisitBefore;
import org.milyn.delivery.ordering.Producer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.expression.MVELExpressionEvaluator;
import org.milyn.javabean.context.BeanContext;
import org.milyn.javabean.repository.BeanId;
import org.milyn.util.CollectionsUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@VisitBeforeIf(condition="!parameters.containsKey('executeAfter') || parameters.executeAfter.value != 'true'")
@VisitAfterIf(condition="parameters.containsKey('executeAfter') && parameters.executeAfter.value == 'true'")
public class Counter
implements SAXVisitBefore,
SAXVisitAfter,
DOMVisitBefore,
DOMVisitAfter,
Producer {
    public static final Long DEFAULT_START_INDEX = new Long(0L);
    public static final int DEFAULT_AMOUNT = 1;
    @ConfigParam(name="beanId")
    private String beanIdName;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private Long start;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private Integer amount;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private MVELExpressionEvaluator amountExpression;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private MVELExpressionEvaluator startExpression;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private MVELExpressionEvaluator resetCondition;
    @ConfigParam(defaultVal="INCREMENT", choice={"INCREMENT", "DECREMENT"})
    private String direction;
    private CountDirection countDirection;
    private BeanId beanId;
    @AppContext
    private ApplicationContext appContext;

    @Initialize
    public void initialize() {
        this.beanId = this.appContext.getBeanIdStore().register(this.beanIdName);
        this.countDirection = CountDirection.valueOf(this.direction);
    }

    @Override
    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.count(executionContext, new Fragment(element));
    }

    @Override
    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.count(executionContext, new Fragment(element));
    }

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.count(executionContext, new Fragment(element));
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.count(executionContext, new Fragment(element));
    }

    public void count(ExecutionContext executionContext, Fragment source) {
        BeanContext beanContext = executionContext.getBeanContext();
        Long value = (Long)beanContext.getBean(this.beanId);
        if (value == null || this.resetCondition != null && this.resetCondition.eval(beanContext.getBeanMap())) {
            value = this.getStart(beanContext);
        } else {
            int amount = this.getAmount(beanContext);
            value = this.countDirection == CountDirection.INCREMENT ? Long.valueOf(value + (long)amount) : Long.valueOf(value - (long)amount);
        }
        beanContext.addBean(this.beanId, (Object)value, source);
    }

    private Long getStart(BeanContext beanContext) {
        if (this.start == null && this.startExpression == null) {
            return DEFAULT_START_INDEX;
        }
        if (this.start != null) {
            return this.start;
        }
        Object result = this.startExpression.getValue(beanContext.getBeanMap());
        if (!(result instanceof Long) && !(result instanceof Integer)) {
            throw new SmooksException("The start expression must result in a Integer or a Long");
        }
        return new Long(result.toString());
    }

    private int getAmount(BeanContext beanContext) {
        if (this.amount == null && this.amountExpression == null) {
            return 1;
        }
        if (this.amount != null) {
            return this.amount;
        }
        Object result = this.amountExpression.getValue(beanContext.getBeanMap());
        if (!(result instanceof Integer)) {
            throw new SmooksException("The amount expression must result in a Integer");
        }
        return (Integer)result;
    }

    @Override
    public Set<? extends Object> getProducts() {
        return CollectionsUtil.toSet(this.beanIdName);
    }
}

