/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.smooks.camel.dataformat;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.DataFormat;
import org.milyn.Smooks;
import org.milyn.container.ExecutionContext;
import org.milyn.payload.Exports;
import org.milyn.payload.StringResult;

public class SmooksDataFormat
implements DataFormat {
    private Smooks smooks;

    public SmooksDataFormat(String smooksConfig) throws Exception {
        this.smooks = new Smooks(smooksConfig);
    }

    public void marshal(Exchange exchange, Object fromBody, OutputStream toStream) throws Exception {
        ExecutionContext execContext = this.smooks.createExecutionContext();
        TypeConverter typeConverter = exchange.getContext().getTypeConverter();
        Source source = (Source)typeConverter.mandatoryConvertTo(Source.class, exchange, fromBody);
        StringResult stringResult = new StringResult();
        this.smooks.filterSource(execContext, source, stringResult);
        toStream.write(stringResult.getResult().getBytes(execContext.getContentEncoding()));
    }

    public Object unmarshal(Exchange exchange, InputStream fromStream) throws Exception {
        ExecutionContext execContext = this.smooks.createExecutionContext();
        Exports exports = Exports.getExports(this.smooks.getApplicationContext());
        Result[] results = exports.createResults();
        this.smooks.filterSource(execContext, new StreamSource(fromStream), results);
        return this.getResult(exports, results, exchange);
    }

    protected Object getResult(Exports exports, Result[] results, Exchange exchange) {
        List<Object> objects = Exports.extractResults(results, exports);
        if (objects.size() == 1) {
            return objects.get(0);
        }
        return objects;
    }
}

