/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.yaml.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.milyn.yaml.handler.EventHandler;
import org.milyn.yaml.handler.YamlEventStreamHandler;
import org.milyn.yaml.handler.YamlToSaxHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.CollectionStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.NodeEvent;
import org.yaml.snakeyaml.events.ScalarEvent;

public class AliasResolvingEventHandler
implements EventHandler {
    private final YamlToSaxHandler contentHandler;
    private final YamlEventStreamHandler eventStreamParser;
    private final boolean addReferenceAttributes;
    private int level = 0;
    private Map<String, Anchor> anchorMap = new HashMap<String, Anchor>();
    private Map<Integer, Anchor> activeAnchorMap = new HashMap<Integer, Anchor>();

    public AliasResolvingEventHandler(YamlEventStreamHandler eventStreamParser, YamlToSaxHandler contentHandler, boolean addReferenceAttributes) {
        this.eventStreamParser = eventStreamParser;
        this.contentHandler = contentHandler;
        this.addReferenceAttributes = addReferenceAttributes;
    }

    public void addValueEvent(ScalarEvent event, String name, String value) throws SAXException {
        this.addValueEvent(event, name, value, true);
    }

    private void addValueEvent(ScalarEvent event, String name, String value, boolean addAnchorAttribute) throws SAXException {
        if (event.getAnchor() != null) {
            this.addValueAnchor((NodeEvent)event);
        }
        this.addToActiveAnchors((Event)event);
        this.contentHandler.addContentElement(name, value, this.getAnchorName((NodeEvent)event), addAnchorAttribute);
    }

    public void startStructureEvent(CollectionStartEvent event, String name) throws SAXException {
        ++this.level;
        if (event.getAnchor() != null) {
            this.addStructureAnchor((NodeEvent)event);
        }
        this.addToActiveAnchors((Event)event);
        this.contentHandler.startElementStructure(name, this.getAnchorName((NodeEvent)event), true);
    }

    public void endStructureEvent(Event event, String name) throws SAXException {
        this.addToActiveAnchors(event);
        this.removeActiveAnchors();
        --this.level;
        this.contentHandler.endElementStructure(name);
    }

    public void addAliasEvent(AliasEvent event, String name) throws SAXException {
        String anchorName = event.getAnchor();
        Anchor anchor = this.anchorMap.get(anchorName);
        if (anchor == null) {
            throw new SAXParseException("A non existing anchor with the name '" + anchorName + "' is referenced by the alias of the element '" + name + "'. The anchor must be declared before it can be referenced by an alias.", null, null, event.getStartMark().getLine(), event.getStartMark().getColumn());
        }
        if (this.activeAnchorMap.values().contains(anchor)) {
            throw new SAXParseException("The alias to anchor '" + anchorName + "' is declared within the element structure in which on of the parent elements declares the anchor. " + "This is not allowed because it leads to infinite loops.", null, null, event.getStartMark().getLine(), event.getStartMark().getColumn());
        }
        if (anchor.isValueAnchor()) {
            ScalarEvent scalarEvent = (ScalarEvent)anchor.getEvents().get(0);
            this.addValueEvent(scalarEvent, name, scalarEvent.getValue(), false);
        } else {
            this.contentHandler.startElementStructure(name, this.getAnchorName((NodeEvent)event), false);
            this.eventStreamParser.handle(this, anchor.getEvents());
            this.contentHandler.endElementStructure(name);
        }
    }

    public void addNameEvent(ScalarEvent event, String name) throws SAXException {
        this.addToActiveAnchors((Event)event);
    }

    private void addValueAnchor(NodeEvent event) {
        Anchor anchor = new Anchor(event.getAnchor(), true);
        anchor.addEvent((Event)event);
        this.anchorMap.put(anchor.getName(), anchor);
    }

    private void addStructureAnchor(NodeEvent event) throws SAXException {
        Anchor anchor = new Anchor(event.getAnchor(), false);
        if (this.activeAnchorMap.values().contains(anchor)) {
            throw new SAXParseException("The anchor '" + anchor.getName() + "' is declared within the data structure of an anchor with the same name.'", null, null, event.getStartMark().getLine(), event.getStartMark().getColumn());
        }
        this.anchorMap.put(anchor.getName(), anchor);
        this.activeAnchorMap.put(this.level, anchor);
    }

    private void addToActiveAnchors(Event event) {
        for (Anchor anchor : this.activeAnchorMap.values()) {
            anchor.addEvent(event);
        }
    }

    private void removeActiveAnchors() {
        this.activeAnchorMap.remove(this.level);
    }

    private String getAnchorName(NodeEvent nodeEvent) {
        return this.addReferenceAttributes ? nodeEvent.getAnchor() : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Anchor {
        private final String name;
        private final boolean valueAnchor;
        private final List<Event> events = new ArrayList<Event>();

        private Anchor(String name, boolean valueAnchor) {
            this.name = name;
            this.valueAnchor = valueAnchor;
        }

        public String getName() {
            return this.name;
        }

        public void addEvent(Event event) {
            this.events.add(event);
        }

        public List<Event> getEvents() {
            return this.events;
        }

        public boolean isValueAnchor() {
            return this.valueAnchor;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.events == null ? 0 : ((Object)this.events).hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Anchor other = (Anchor)obj;
            if (this.events == null ? other.events != null : !((Object)this.events).equals(other.events)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

