/*
 * Decompiled with CFR 0.152.
 */
package org.milyn;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.milyn.ReaderConfigurator;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.xml.sax.XMLReader;

public class GenericReaderConfigurator
implements ReaderConfigurator {
    private Class readerClass;
    private Properties parameters = new Properties();
    private List<String> featuresOn = new ArrayList<String>();
    private List<String> featuresOff = new ArrayList<String>();
    private String targetProfile;

    public GenericReaderConfigurator() {
    }

    public GenericReaderConfigurator(Class<? extends XMLReader> readerClass) {
        this.readerClass = readerClass;
    }

    public Properties getParameters() {
        return this.parameters;
    }

    public GenericReaderConfigurator setParameters(Properties parameters) {
        this.parameters = parameters;
        return this;
    }

    public GenericReaderConfigurator setFeature(String feature, boolean on) {
        if (on) {
            this.featuresOn.add(feature);
        } else {
            this.featuresOff.add(feature);
        }
        return this;
    }

    public GenericReaderConfigurator setTargetProfile(String targetProfile) {
        this.targetProfile = targetProfile;
        return this;
    }

    @Override
    public List<SmooksResourceConfiguration> toConfig() {
        SmooksResourceConfiguration smooksConfig = new SmooksResourceConfiguration();
        smooksConfig.setSelector("org.xml.sax.driver");
        if (this.readerClass != null) {
            smooksConfig.setResource(this.readerClass.getName());
        }
        if (this.targetProfile != null) {
            smooksConfig.setTargetProfile(this.targetProfile);
        }
        Set<Map.Entry<Object, Object>> entries = this.parameters.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            smooksConfig.setParameter((String)entry.getKey(), (String)entry.getValue());
        }
        for (String featureOn : this.featuresOn) {
            smooksConfig.setParameter("feature-on", featureOn);
        }
        for (String featureOff : this.featuresOff) {
            smooksConfig.setParameter("feature-off", featureOff);
        }
        ArrayList<SmooksResourceConfiguration> configList = new ArrayList<SmooksResourceConfiguration>();
        configList.add(smooksConfig);
        return configList;
    }
}

