/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.nested;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.milyn.Smooks;
import org.milyn.SmooksException;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.AbstractParser;
import org.milyn.delivery.Fragment;
import org.milyn.delivery.SmooksContentHandler;
import org.milyn.delivery.VisitLifecycleCleanable;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.annotation.Uninitialize;
import org.milyn.delivery.ordering.Producer;
import org.milyn.delivery.sax.DynamicSAXElementVisitorList;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXHandler;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.javabean.context.BeanContext;
import org.milyn.javabean.lifecycle.BeanContextLifecycleEvent;
import org.milyn.javabean.lifecycle.BeanLifecycle;
import org.milyn.javabean.repository.BeanId;
import org.milyn.namespace.NamespaceDeclarationStack;
import org.milyn.util.CollectionsUtil;
import org.milyn.xml.NamespaceMappings;
import org.xml.sax.XMLReader;

public class NestedExecutionVisitor
implements SAXVisitBefore,
VisitLifecycleCleanable,
Producer {
    @ConfigParam
    private String smooksConfig;
    @ConfigParam
    private String[] mapBeans;
    private List<BeanId> mapBeanIds = new ArrayList<BeanId>();
    @ConfigParam(defaultVal="true")
    private boolean inheritBeanContext;
    @AppContext
    private ApplicationContext applicationContext;
    private volatile Smooks smooksInstance;

    public void setSmooksConfig(String smooksConfig) {
        this.smooksConfig = smooksConfig;
    }

    public void setSmooksInstance(Smooks smooksInstance) {
        this.smooksInstance = smooksInstance;
    }

    @Initialize
    public void preRegBeanIds() {
        for (String preRegBeanId : this.mapBeans) {
            this.mapBeanIds.add(this.applicationContext.getBeanIdStore().register(preRegBeanId));
        }
    }

    @Uninitialize
    public void closeSmooksInstance() {
        if (this.smooksInstance != null) {
            this.smooksInstance.close();
        }
    }

    @Override
    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        Smooks smooks = this.getSmooksInstance();
        ExecutionContext nestedExecutionContext = smooks.createExecutionContext();
        nestedExecutionContext.setEventListener(executionContext.getEventListener());
        AbstractParser.setReaders(AbstractParser.getReaders(executionContext), nestedExecutionContext);
        NamespaceDeclarationStack nsStack = NamespaceMappings.getNamespaceDeclarationStack(executionContext);
        NamespaceMappings.setNamespaceDeclarationStack(nsStack, nestedExecutionContext);
        SmooksContentHandler parentContentHandler = SmooksContentHandler.getHandler(executionContext);
        if (parentContentHandler.getNestedContentHandler() != null) {
            throw new SmooksException("Illegal use of more than one nested content handler fired on the same element.");
        }
        SAXHandler nestedContentHandler = new SAXHandler(nestedExecutionContext, element.getWriter(this), parentContentHandler);
        DynamicSAXElementVisitorList.propogateDynamicVisitors(executionContext, nestedExecutionContext);
        XMLReader xmlReader = AbstractParser.getXMLReader(executionContext);
        AbstractParser.attachXMLReader(xmlReader, nestedExecutionContext);
        xmlReader.setContentHandler(nestedContentHandler);
        executionContext.setAttribute(NestedExecutionVisitor.class, nestedExecutionContext);
    }

    @Override
    public Set<? extends Object> getProducts() {
        return CollectionsUtil.toSet(this.mapBeans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Smooks getSmooksInstance() {
        if (this.smooksInstance == null) {
            NestedExecutionVisitor nestedExecutionVisitor = this;
            synchronized (nestedExecutionVisitor) {
                if (this.smooksInstance == null) {
                    try {
                        this.smooksInstance = new Smooks(this.smooksConfig);
                    }
                    catch (Exception e) {
                        throw new SmooksException("Error creating nested Smooks instance for Smooks configuration '" + this.smooksConfig + "'.", e);
                    }
                }
            }
        }
        return this.smooksInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeVisitLifecycleCleanup(Fragment fragment, ExecutionContext executionContext) {
        try {
            ExecutionContext nestedExecutionContext = (ExecutionContext)executionContext.getAttribute(NestedExecutionVisitor.class);
            try {
                if (nestedExecutionContext != null) {
                    BeanContext parentBeanContext = executionContext.getBeanContext();
                    BeanContext nestedBeanContext = nestedExecutionContext.getBeanContext();
                    for (BeanId beanId : this.mapBeanIds) {
                        Object bean = nestedBeanContext.getBean(beanId.getName());
                        parentBeanContext.notifyObservers(new BeanContextLifecycleEvent(executionContext, null, BeanLifecycle.START_FRAGMENT, beanId, bean));
                        parentBeanContext.addBean(beanId, bean);
                        parentBeanContext.notifyObservers(new BeanContextLifecycleEvent(executionContext, null, BeanLifecycle.END_FRAGMENT, beanId, bean));
                        parentBeanContext.removeBean(beanId, null);
                    }
                }
            }
            finally {
                executionContext.removeAttribute(NestedExecutionVisitor.class);
            }
        }
        finally {
            AbstractParser.detachXMLReader(executionContext);
        }
    }
}

