/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.unedifact.handlers.r41;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.edisax.interchange.ControlBlockHandler;
import org.milyn.edisax.interchange.ControlBlockHandlerFactory;
import org.milyn.edisax.model.EDIConfigDigester;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.model.internal.SegmentGroup;
import org.milyn.edisax.unedifact.handlers.GenericHandler;
import org.milyn.edisax.unedifact.handlers.UNAHandler;
import org.milyn.edisax.unedifact.handlers.UNBHandler;
import org.milyn.edisax.unedifact.handlers.UNGHandler;
import org.milyn.edisax.unedifact.handlers.UNHHandler;
import org.milyn.xml.hierarchy.HierarchyChangeListener;
import org.xml.sax.SAXException;

public class UNEdifact41ControlBlockHandlerFactory
implements ControlBlockHandlerFactory {
    private static Log logger = LogFactory.getLog(UNBHandler.class);
    public static final String NAMESPACE = "urn:org.milyn.edi.unedifact.v41";
    private static Segment unbSegment;
    private static Segment unzSegment;
    private static Segment ungSegment;
    private static Segment uneSegment;
    private static Segment unhSegment;
    private static Segment untSegment;
    private static HashMap<String, Charset> toCharsetMapping;
    private HierarchyChangeListener hierarchyChangeListener;

    public UNEdifact41ControlBlockHandlerFactory(HierarchyChangeListener hierarchyChangeListener) {
        this.hierarchyChangeListener = hierarchyChangeListener;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public ControlBlockHandler getControlBlockHandler(String segCode) throws SAXException {
        if (segCode.equals("UNH")) {
            return new UNHHandler(unhSegment, untSegment, this.hierarchyChangeListener);
        }
        if (segCode.equals("UNG")) {
            return new UNGHandler(ungSegment, uneSegment);
        }
        if (segCode.equals("UNA")) {
            return new UNAHandler();
        }
        if (segCode.equals("UNB")) {
            return new UNBHandler(unbSegment, unzSegment, toCharsetMapping);
        }
        if (segCode.charAt(0) == 'U') {
            return new GenericHandler();
        }
        throw new SAXException("Unknown/Unexpected UN/EDIFACT control block segment code '" + segCode + "'.");
    }

    private static void addCharsetMapping(String code, String charsetName) {
        if (Charset.isSupported(charsetName)) {
            toCharsetMapping.put(code, Charset.forName(charsetName));
        } else {
            logger.debug((Object)("Unsupported character set '" + charsetName + "'.  Cannot support for '" + code + "' if defined on the syntaxIdentifier field on the UNB segment.  Check the JVM version etc."));
        }
    }

    static {
        try {
            Edimap controlBlockSegments = EDIConfigDigester.digestConfig(UNEdifact41ControlBlockHandlerFactory.class.getResourceAsStream("v41-segments.xml"));
            List<SegmentGroup> segments = controlBlockSegments.getSegments().getSegments();
            for (SegmentGroup segment : segments) {
                if (segment.getSegcode().equals("UNB")) {
                    unbSegment = (Segment)segment;
                    continue;
                }
                if (segment.getSegcode().equals("UNZ")) {
                    unzSegment = (Segment)segment;
                    continue;
                }
                if (segment.getSegcode().equals("UNG")) {
                    ungSegment = (Segment)segment;
                    continue;
                }
                if (segment.getSegcode().equals("UNE")) {
                    uneSegment = (Segment)segment;
                    continue;
                }
                if (segment.getSegcode().equals("UNH")) {
                    unhSegment = (Segment)segment;
                    continue;
                }
                if (!segment.getSegcode().equals("UNT")) continue;
                untSegment = (Segment)segment;
            }
        }
        catch (Exception e) {
            throw new SmooksConfigurationException("Unexpected exception reading UN/EDIFACT v4.1 segment definitions.", e);
        }
        toCharsetMapping = new HashMap();
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("UNOA", "ASCII");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("UNOB", "ASCII");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("UNOC", "ISO8859-1");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("UNOD", "ISO8859-2");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("UNOE", "ISO8859-5");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("UNOF", "ISO8859-7");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("UNOG", "ISO8859-3");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("UNOH", "ISO8859-4");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("UNOI", "ISO8859-6");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("UNOJ", "ISO8859-8");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("UNOK", "ISO8859-9");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("UNOL", "ISO8859-15");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("UNOW", "UTF-8");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("UNOX", "ISO-2022-CN");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("UNOY", "UTF-8");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("1", "ASCII");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("2", "ASCII");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("3", "IBM500");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("4", "IBM850");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("5", "UTF-16");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("6", "UTF-32");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("7", "UTF-8");
        UNEdifact41ControlBlockHandlerFactory.addCharsetMapping("8", "UTF-16");
    }
}

