/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.flatfile.variablefield;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.flatfile.FieldMetaData;
import org.milyn.flatfile.RecordMetaData;
import org.milyn.function.StringFunctionExecutor;

public class VariableFieldRecordMetaData {
    public static final Pattern SINGLE_RECORD_PATTERN = Pattern.compile("^[\\w|[?$-_, ]]+$");
    public static final Pattern MULTI_RECORD_PATTERN = Pattern.compile("^([\\w|[?$-_*]]+)\\[([\\w|[?$-_, *]]+)\\]$");
    private RecordMetaData recordMetaData;
    private Map<String, RecordMetaData> recordMetaDataMap;
    public static RecordMetaData UNKNOWN_RECORD_TYPE = new RecordMetaData("UNMATCHED", new ArrayList<FieldMetaData>());

    public VariableFieldRecordMetaData(String recordElementName, String fields) {
        if (fields == null) {
            this.recordMetaData = new RecordMetaData(recordElementName, new ArrayList<FieldMetaData>(), true);
        } else {
            List<String> recordDefs = Arrays.asList(fields.split("\\|"));
            for (int i = 0; i < recordDefs.size(); ++i) {
                recordDefs.set(i, recordDefs.get(i).trim());
            }
            if (recordDefs.size() == 1) {
                if (SINGLE_RECORD_PATTERN.matcher(recordDefs.get(0)).matches()) {
                    this.recordMetaData = this.buildRecordMetaData(recordElementName, recordDefs.get(0).split(","));
                    return;
                }
                this.recordMetaData = this.buildMultiRecordMetaData(recordDefs.get(0));
                if (this.recordMetaData == null) {
                    throw new SmooksConfigurationException("Unsupported fields definition '" + fields + "'.  Must match either the single ('" + SINGLE_RECORD_PATTERN.pattern() + "') or multi ('" + MULTI_RECORD_PATTERN.pattern() + "') record pattern.");
                }
            } else {
                for (String recordDef : recordDefs) {
                    RecordMetaData multiRecordMetaData = this.buildMultiRecordMetaData(recordDef = recordDef.trim());
                    if (multiRecordMetaData == null) {
                        throw new SmooksConfigurationException("Unsupported fields definition '" + recordDef + "'.  Must match the multi record pattern ('" + MULTI_RECORD_PATTERN.pattern() + "') .");
                    }
                    if (this.recordMetaDataMap == null) {
                        this.recordMetaDataMap = new HashMap<String, RecordMetaData>();
                    }
                    this.recordMetaDataMap.put(multiRecordMetaData.getName(), multiRecordMetaData);
                }
            }
        }
    }

    public boolean isMultiTypeRecordSet() {
        return this.recordMetaData == null && this.recordMetaDataMap != null;
    }

    public RecordMetaData getRecordMetaData() {
        if (this.isMultiTypeRecordSet()) {
            throw new IllegalStateException("Invalid call to getRecordMetaData().  This is a multi-type record set.  Must call getRecordMetaData(String recordTypeName).");
        }
        return this.recordMetaData;
    }

    public RecordMetaData getRecordMetaData(String recordTypeName) {
        AssertArgument.isNotNullAndNotEmpty(recordTypeName, "recordTypeName");
        if (!this.isMultiTypeRecordSet()) {
            throw new IllegalStateException("Invalid call to getRecordMetaData(String recordTypeName).  This is not a multi-type record set.  Must call getRecordMetaData().");
        }
        return this.recordMetaDataMap.get(recordTypeName);
    }

    public RecordMetaData getRecordMetaData(String[] record) {
        AssertArgument.isNotNullAndNotEmpty(record, "record");
        if (!this.isMultiTypeRecordSet()) {
            return this.recordMetaData;
        }
        return this.recordMetaDataMap.get(record[0].trim());
    }

    public RecordMetaData getRecordMetaData(Collection<String> record) {
        AssertArgument.isNotNullAndNotEmpty(record, "record");
        if (!this.isMultiTypeRecordSet()) {
            return this.recordMetaData;
        }
        RecordMetaData vrecordMetaData = this.recordMetaDataMap.get(record.iterator().next().trim());
        if (vrecordMetaData == null) {
            vrecordMetaData = UNKNOWN_RECORD_TYPE;
        }
        return vrecordMetaData;
    }

    public RecordMetaData buildMultiRecordMetaData(String recordDef) {
        Matcher matcher = MULTI_RECORD_PATTERN.matcher(recordDef);
        if (matcher.matches()) {
            return this.buildRecordMetaData(matcher.group(1), matcher.group(2).split(","));
        }
        return null;
    }

    private RecordMetaData buildRecordMetaData(String recordName, String[] fieldNames) {
        return VariableFieldRecordMetaData.buildRecordMetaData(recordName, Arrays.asList(fieldNames));
    }

    public static RecordMetaData buildRecordMetaData(String recordName, List<String> fieldNames) {
        ArrayList<FieldMetaData> fieldsMetaData = new ArrayList<FieldMetaData>();
        for (int i = 0; i < fieldNames.size(); ++i) {
            FieldMetaData fieldMetaData;
            String fieldSpec = fieldNames.get(i).trim();
            if (fieldSpec.equals("*")) {
                return new RecordMetaData(recordName, fieldsMetaData, true);
            }
            if (fieldSpec.indexOf(63) >= 0) {
                String fieldName = fieldSpec.substring(0, fieldSpec.indexOf(63));
                String functionDefinition = fieldSpec.substring(fieldSpec.indexOf(63) + 1);
                fieldMetaData = new FieldMetaData(fieldName);
                if (functionDefinition.length() != 0) {
                    fieldMetaData.setStringFunctionExecutor(StringFunctionExecutor.getInstance(functionDefinition));
                }
            } else {
                fieldMetaData = new FieldMetaData(fieldSpec);
            }
            fieldsMetaData.add(fieldMetaData);
            if (!fieldMetaData.ignore() || fieldMetaData.getIgnoreCount() <= 1 || fieldMetaData.getIgnoreCount() >= Integer.MAX_VALUE) continue;
            for (int ii = 0; ii < fieldMetaData.getIgnoreCount() - 1; ++ii) {
                fieldsMetaData.add(new FieldMetaData("$ignore$"));
            }
        }
        return new RecordMetaData(recordName, fieldsMetaData);
    }

    static {
        UNKNOWN_RECORD_TYPE.getFields().add(new FieldMetaData("value"));
    }
}

