/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.function;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.milyn.function.CapitalizeFirstFunction;
import org.milyn.function.CapitalizeFunction;
import org.milyn.function.LeftTrimFunction;
import org.milyn.function.LowerCaseFunction;
import org.milyn.function.RightTrimFunction;
import org.milyn.function.StringFunction;
import org.milyn.function.TrimFunction;
import org.milyn.function.UncapitalizeFirstFunction;
import org.milyn.function.UnknownStringFunctionException;
import org.milyn.function.UpperCaseFunction;

public class StringFunctionDefinitionParser {
    public static final TrimFunction TRIM_FUNCTION = new TrimFunction();
    public static final LeftTrimFunction LEFT_TRIM_FUNCTION = new LeftTrimFunction();
    public static final RightTrimFunction RIGHT_TRIM_FUNCTION = new RightTrimFunction();
    public static final UpperCaseFunction UPPER_CASE_FUNCTION = new UpperCaseFunction();
    public static final LowerCaseFunction LOWER_CASE_FUNCTION = new LowerCaseFunction();
    public static final CapitalizeFunction CAPITALIZE_FUNCTION = new CapitalizeFunction();
    public static final CapitalizeFirstFunction CAPITALIZE_FIRST_FUNCTION = new CapitalizeFirstFunction();
    public static final UncapitalizeFirstFunction UNCAPITALIZE_FIRST_FUNCTION = new UncapitalizeFirstFunction();
    public static final String TRIM_DEFINITION = "trim";
    public static final String LEFT_TRIM_DEFINITION = "left_trim";
    public static final String RIGHT_TRIM_DEFINITION = "right_trim";
    public static final String UPPER_CASE_DEFINITION = "upper_case";
    public static final String LOWER_CASE_DEFINITION = "lower_case";
    public static final String CAPITALIZE_DEFINITION = "capitalize";
    public static final String CAPITALIZE_FIRST_DEFINITION = "cap_first";
    public static final String UNCAPITALIZE_FIRST_DEFINITION = "uncap_first";
    public static final char SEPARATOR = '.';

    private StringFunctionDefinitionParser() {
    }

    public static List<StringFunction> parse(String definition) {
        String[] functionsDef;
        ArrayList<StringFunction> functions = new ArrayList<StringFunction>();
        for (String functionDef : functionsDef = StringUtils.split((String)definition, (char)'.')) {
            if (functionDef.equals(TRIM_DEFINITION)) {
                functions.add(TRIM_FUNCTION);
                continue;
            }
            if (functionDef.equals(LEFT_TRIM_DEFINITION)) {
                functions.add(LEFT_TRIM_FUNCTION);
                continue;
            }
            if (functionDef.equals(RIGHT_TRIM_DEFINITION)) {
                functions.add(RIGHT_TRIM_FUNCTION);
                continue;
            }
            if (functionDef.equals(UPPER_CASE_DEFINITION)) {
                functions.add(UPPER_CASE_FUNCTION);
                continue;
            }
            if (functionDef.equals(LOWER_CASE_DEFINITION)) {
                functions.add(LOWER_CASE_FUNCTION);
                continue;
            }
            if (functionDef.equals(CAPITALIZE_DEFINITION)) {
                functions.add(CAPITALIZE_FUNCTION);
                continue;
            }
            if (functionDef.equals(CAPITALIZE_FIRST_DEFINITION)) {
                functions.add(CAPITALIZE_FIRST_FUNCTION);
                continue;
            }
            if (functionDef.equals(UNCAPITALIZE_FIRST_DEFINITION)) {
                functions.add(UNCAPITALIZE_FIRST_FUNCTION);
                continue;
            }
            throw new UnknownStringFunctionException("The function '" + functionDef + "' in the function definition '" + definition + "' is unknown.");
        }
        return functions;
    }
}

