/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.context;

import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.milyn.container.ExecutionContext;
import org.milyn.javabean.context.BeanIdStore;
import org.milyn.javabean.context.StandaloneBeanContext;
import org.milyn.payload.FilterResult;
import org.milyn.payload.FilterSource;
import org.milyn.payload.JavaResult;
import org.milyn.payload.JavaSource;

public class StandaloneBeanContextFactory {
    public static StandaloneBeanContext create(ExecutionContext executionContext) {
        BeanIdStore beanIdStore = executionContext.getContext().getBeanIdStore();
        Map<String, Object> beanMap = StandaloneBeanContextFactory.createBeanMap(executionContext, beanIdStore);
        StandaloneBeanContext beanContext = new StandaloneBeanContext(executionContext, beanIdStore, beanMap);
        return beanContext;
    }

    private static Map<String, Object> createBeanMap(ExecutionContext executionContext, BeanIdStore beanIdStore) {
        JavaSource javaSource;
        Map<String, Object> sourceBeans;
        Result result = FilterResult.getResult(executionContext, JavaResult.class);
        Source source = FilterSource.getSource(executionContext);
        Map<String, Object> beanMap = null;
        if (result != null) {
            JavaResult javaResult = (JavaResult)result;
            beanMap = javaResult.getResultMap();
        }
        if (source instanceof JavaSource && (sourceBeans = (javaSource = (JavaSource)source).getBeans()) != null) {
            if (beanMap != null) {
                beanMap.putAll(sourceBeans);
            } else {
                beanMap = sourceBeans;
            }
        }
        if (beanMap == null) {
            beanMap = new HashMap<String, Object>();
        } else {
            for (String beanId : beanMap.keySet()) {
                if (beanIdStore.containsBeanId(beanId)) continue;
                beanIdStore.register(beanId);
            }
        }
        return beanMap;
    }
}

