/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.rules;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.delivery.ContentHandler;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.rules.RuleProvider;
import org.milyn.rules.RuleProviderAccessor;

public final class RulesProviderFactory
implements ContentHandler<RuleProvider> {
    private static Log logger = LogFactory.getLog(RulesProviderFactory.class);
    @AppContext
    private ApplicationContext applicationContext;
    @ConfigParam(use=ConfigParam.Use.REQUIRED)
    private String name;
    @ConfigParam(name="provider", use=ConfigParam.Use.REQUIRED)
    private Class<RuleProvider> provider;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String src;

    @Initialize
    public void installRuleProvider() throws SmooksConfigurationException {
        logger.debug((Object)this);
        if (!RuleProvider.class.isAssignableFrom(this.provider)) {
            throw new SmooksConfigurationException("Invalid rule provider configuration :'" + this + "'");
        }
        RuleProvider providerImpl = this.createProvider(this.provider);
        providerImpl.setName(this.name);
        providerImpl.setSrc(this.src);
        RuleProviderAccessor.add(this.applicationContext, providerImpl);
    }

    RuleProvider createProvider(Class<? extends RuleProvider> providerClass) throws SmooksException {
        try {
            return providerClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new SmooksException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new SmooksException(e.getMessage(), e);
        }
    }

    public String toString() {
        return String.format("%s [name=%s, src=%s, provider=%s]", this.getClass().getSimpleName(), this.name, this.src, this.provider);
    }
}

