/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.scribe.adapter.jpa;

import java.util.Collection;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.milyn.assertion.AssertArgument;
import org.milyn.scribe.Dao;
import org.milyn.scribe.Flushable;
import org.milyn.scribe.Locator;
import org.milyn.scribe.Queryable;

class EntityManagerDaoAdapter
implements Dao<Object>,
Locator,
Queryable,
Flushable {
    private final EntityManager entityManager;

    public EntityManagerDaoAdapter(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void flush() {
        this.entityManager.flush();
    }

    @Override
    public Object update(Object entity) {
        AssertArgument.isNotNull(entity, "entity");
        return this.entityManager.merge(entity);
    }

    @Override
    public Object insert(Object entity) {
        AssertArgument.isNotNull(entity, "entity");
        this.entityManager.persist(entity);
        return null;
    }

    @Override
    public Object delete(Object entity) {
        AssertArgument.isNotNull(entity, "entity");
        this.entityManager.remove(entity);
        return null;
    }

    @Override
    public Collection<Object> lookup(String name, Object ... parameters) {
        AssertArgument.isNotNullAndNotEmpty(name, "name");
        AssertArgument.isNotNull(parameters, "parameters");
        Query emQuery = this.entityManager.createNamedQuery(name);
        for (int i = 0; i < parameters.length; ++i) {
            emQuery.setParameter(i + 1, parameters[i]);
        }
        return emQuery.getResultList();
    }

    @Override
    public Collection<Object> lookup(String name, Map<String, ?> parameters) {
        AssertArgument.isNotNullAndNotEmpty(name, "name");
        AssertArgument.isNotNull(parameters, "parameters");
        Query emQuery = this.entityManager.createNamedQuery(name);
        for (String key : parameters.keySet()) {
            emQuery.setParameter(key, parameters.get(key));
        }
        return emQuery.getResultList();
    }

    @Override
    public Collection<Object> lookupByQuery(String query, Object ... parameters) {
        AssertArgument.isNotNullAndNotEmpty(query, "query");
        AssertArgument.isNotNull(parameters, "parameters");
        if (query.startsWith("@")) {
            return this.lookup(query.substring(1), parameters);
        }
        Query emQuery = this.entityManager.createQuery(query);
        for (int i = 0; i < parameters.length; ++i) {
            emQuery.setParameter(i + 1, parameters[i]);
        }
        return emQuery.getResultList();
    }

    @Override
    public Collection<Object> lookupByQuery(String query, Map<String, ?> parameters) {
        AssertArgument.isNotNullAndNotEmpty(query, "query");
        AssertArgument.isNotNull(parameters, "parameters");
        if (query.startsWith("@")) {
            return this.lookup(query.substring(1), (Map)parameters);
        }
        Query emQuery = this.entityManager.createQuery(query);
        for (String key : parameters.keySet()) {
            emQuery.setParameter(key, parameters.get(key));
        }
        return emQuery.getResultList();
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }
}

