/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.csv;

import java.util.List;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.csv.CSVRecordParserFactory;
import org.milyn.flatfile.variablefield.VariableFieldRecordParserConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVRecordParserConfigurator
extends VariableFieldRecordParserConfigurator {
    private String csvFields;
    private char separatorChar = (char)44;
    private char quoteChar = (char)34;
    private char escapeChar = (char)92;
    private int skipLineCount = 0;
    private String rootElementName = "csv-set";
    private String recordElementName = "csv-record";

    public CSVRecordParserConfigurator(String csvFields) {
        super(CSVRecordParserFactory.class);
        AssertArgument.isNotNullAndNotEmpty((String)csvFields, (String)"csvFields");
        this.csvFields = csvFields;
    }

    public CSVRecordParserConfigurator setSeparatorChar(char separatorChar) {
        AssertArgument.isNotNull((Object)Character.valueOf(separatorChar), (String)"separatorChar");
        this.separatorChar = separatorChar;
        return this;
    }

    public CSVRecordParserConfigurator setQuoteChar(char quoteChar) {
        AssertArgument.isNotNull((Object)Character.valueOf(quoteChar), (String)"quoteChar");
        this.quoteChar = quoteChar;
        return this;
    }

    public CSVRecordParserConfigurator setEscapeChar(char escapeChar) {
        AssertArgument.isNotNull((Object)Character.valueOf(escapeChar), (String)"escapeChar");
        this.escapeChar = escapeChar;
        return this;
    }

    public CSVRecordParserConfigurator setSkipLineCount(int skipLineCount) {
        AssertArgument.isNotNull((Object)skipLineCount, (String)"skipLineCount");
        this.skipLineCount = skipLineCount;
        return this;
    }

    public CSVRecordParserConfigurator setRootElementName(String csvRootElementName) {
        AssertArgument.isNotNullAndNotEmpty((String)csvRootElementName, (String)"rootElementName");
        this.rootElementName = csvRootElementName;
        return this;
    }

    public CSVRecordParserConfigurator setRecordElementName(String csvRecordElementName) {
        AssertArgument.isNotNullAndNotEmpty((String)csvRecordElementName, (String)"recordElementName");
        this.recordElementName = csvRecordElementName;
        return this;
    }

    public List<SmooksResourceConfiguration> toConfig() {
        this.getParameters().setProperty("fields", this.csvFields);
        this.getParameters().setProperty("separator", Character.toString(this.separatorChar));
        this.getParameters().setProperty("quote-char", Character.toString(this.quoteChar));
        this.getParameters().setProperty("escape-char", Character.toString(this.escapeChar));
        this.getParameters().setProperty("skip-line-count", Integer.toString(this.skipLineCount));
        this.getParameters().setProperty("rootElementName", this.rootElementName);
        this.getParameters().setProperty("recordElementName", this.recordElementName);
        return super.toConfig();
    }
}

