/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.csv.prog;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.UUID;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.milyn.FilterSettings;
import org.milyn.ReaderConfigurator;
import org.milyn.Smooks;
import org.milyn.assertion.AssertArgument;
import org.milyn.csv.CSVRecordParserConfigurator;
import org.milyn.flatfile.Binding;
import org.milyn.flatfile.BindingType;
import org.milyn.payload.JavaResult;

public class CSVListBinder {
    private String beanId = UUID.randomUUID().toString();
    private Smooks smooks;

    public CSVListBinder(String fields, Class recordType) {
        AssertArgument.isNotNullAndNotEmpty((String)fields, (String)"fields");
        AssertArgument.isNotNull((Object)recordType, (String)"recordType");
        this.smooks = new Smooks();
        this.smooks.setFilterSettings(FilterSettings.DEFAULT_SAX);
        this.smooks.setReaderConfig((ReaderConfigurator)new CSVRecordParserConfigurator(fields).setBinding(new Binding(this.beanId, recordType, BindingType.LIST)));
    }

    public List bind(Reader csvStream) {
        AssertArgument.isNotNull((Object)csvStream, (String)"csvStream");
        JavaResult javaResult = new JavaResult();
        this.smooks.filterSource((Source)new StreamSource(csvStream), new Result[]{javaResult});
        return (List)javaResult.getBean(this.beanId);
    }

    public List bind(InputStream csvStream) {
        return this.bind(new InputStreamReader(csvStream));
    }
}

