/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ect.ecore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.milyn.ect.ecore.ECoreConversionUtils;
import org.milyn.edisax.interchange.EdiDirectory;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.model.internal.SegmentGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ECoreGenerator {
    public static final ECoreGenerator INSTANCE = new ECoreGenerator();
    public static final String COMMON_PACKAGE_NAME = "common";
    private static final Log log = LogFactory.getLog(ECoreGenerator.class);

    public Set<EPackage> generatePackages(EdiDirectory ediDirectory) {
        log.debug((Object)"Converting UN EDIFACT Model");
        HashSet<EPackage> result = new HashSet<EPackage>();
        Edimap commonModel = ediDirectory.getCommonModel();
        HashMap<String, EClass> commonClasses = new HashMap<String, EClass>();
        EPackage commonPackage = EcoreFactory.eINSTANCE.createEPackage();
        commonPackage.setName(COMMON_PACKAGE_NAME);
        commonPackage.setNsPrefix(COMMON_PACKAGE_NAME);
        commonPackage.setNsURI(commonModel.getDescription().getNamespace());
        Collection<EClass> clzz = this.createCommonClasses(commonModel, commonClasses);
        commonPackage.getEClassifiers().addAll(clzz);
        result.add(commonPackage);
        for (Edimap mappingModel : ediDirectory.getMessageModels()) {
            EPackage pkg = this.processPackage(mappingModel, commonClasses);
            if (result.add(pkg)) continue;
            log.warn((Object)("WARN: Duplicated package " + pkg.getName() + " for "));
        }
        log.debug((Object)("Converted EDIFACT Model  into " + result.size() + " EPackages"));
        return result;
    }

    public EPackage generateSinglePackage(Edimap mappingModel) {
        HashMap<String, EClass> commonClasses = new HashMap<String, EClass>();
        EPackage result = this.processPackage(mappingModel, commonClasses);
        result.getEClassifiers().addAll(commonClasses.values());
        return result;
    }

    private EPackage processPackage(Edimap mappingModel, Map<String, EClass> commonClasses) {
        EPackage pkg = ECoreConversionUtils.mappingModelToEPackage(mappingModel);
        pkg.getEClassifiers().addAll(this.createMappingClases(mappingModel.getSegments(), commonClasses));
        return pkg;
    }

    private Set<EClass> createMappingClases(SegmentGroup root, Map<String, EClass> commonClasses) {
        HashSet<EClass> result = new HashSet<EClass>();
        EClass rootClass = ECoreConversionUtils.segmentGroupToEClass(root);
        rootClass.setName(rootClass.getName().toUpperCase());
        result.add(rootClass);
        ExtendedMetaData.INSTANCE.setName((EClassifier)rootClass, rootClass.getName());
        result.add(ECoreConversionUtils.createDocumentRoot(rootClass));
        this.processSegments(root.getSegments(), commonClasses, result, rootClass);
        return result;
    }

    private void processSegments(List<SegmentGroup> segments, Map<String, EClass> commonClasses, Set<EClass> result, EClass parent) {
        for (SegmentGroup arg0 : segments) {
            if (arg0 instanceof Segment) {
                Segment segment = (Segment)arg0;
                EClass clazz = null;
                if (segment.getNodeTypeRef() == null) {
                    clazz = ECoreConversionUtils.segmentToEClass(segment);
                    if (!segment.getFields().isEmpty()) {
                        commonClasses.put(segment.getSegcode(), clazz);
                        Collection<EStructuralFeature> fields = this.processFields(segment.getFields(), commonClasses);
                        clazz.getEStructuralFeatures().addAll(fields);
                    }
                    result.add(clazz);
                } else {
                    clazz = commonClasses.get(this.getLocalPart(segment));
                }
                EReference segmentRef = ECoreConversionUtils.segmentToEReference(segment, clazz);
                if (parent.getEStructuralFeature(segmentRef.getName()) == null) {
                    parent.getEStructuralFeatures().add((Object)segmentRef);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Duplicate segment " + segmentRef.getName() + " (tag: " + ExtendedMetaData.INSTANCE.getName((EStructuralFeature)segmentRef) + ")" + " in " + parent.getName()));
                continue;
            }
            if (!(arg0 instanceof SegmentGroup)) continue;
            SegmentGroup grp = arg0;
            EClass refClass = ECoreConversionUtils.segmentGroupToEClass(grp);
            EReference reference = ECoreConversionUtils.segmentGroupToEReference(grp, refClass);
            if (parent.getEStructuralFeature(reference.getName()) == null) {
                parent.getEStructuralFeatures().add((Object)reference);
            }
            if (!result.add(refClass)) {
                throw new RuntimeException("Reference class " + refClass.getName() + " is duplicated in package");
            }
            this.processSegments(grp.getSegments(), commonClasses, result, refClass);
        }
    }

    private Collection<EClass> createCommonClasses(Edimap commonModel, Map<String, EClass> commonClasses) {
        HashMap<String, EClass> result = new HashMap<String, EClass>();
        for (SegmentGroup grp : commonModel.getSegments().getSegments()) {
            Segment segment = (Segment)grp;
            EClass clazz = ECoreConversionUtils.segmentToEClass(segment);
            if (!segment.getFields().isEmpty()) {
                commonClasses.put(segment.getSegcode(), clazz);
                Collection<EStructuralFeature> fields = this.processFields(segment.getFields(), result);
                clazz.getEStructuralFeatures().addAll(fields);
            }
            result.put(clazz.getName(), clazz);
        }
        EClass droot = ECoreConversionUtils.createDocumentRoot(null);
        result.put(droot.getName(), droot);
        return result.values();
    }

    private Collection<EStructuralFeature> processFields(List<Field> fields, Map<String, EClass> classes) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        HashSet<String> names = new HashSet<String>();
        for (Field field : fields) {
            if (field.getComponents().isEmpty()) {
                EAttribute attribute = ECoreConversionUtils.fieldToEAttribute(field);
                if (names.contains(attribute.getName())) continue;
                result.add((EStructuralFeature)attribute);
                names.add(attribute.getName());
                continue;
            }
            EReference reference = ECoreConversionUtils.fieldToEReference(field, classes);
            if (names.contains(reference.getName())) continue;
            result.add((EStructuralFeature)reference);
            names.add(reference.getName());
        }
        return result;
    }

    private String getLocalPart(Segment segment) {
        String ref = segment.getNodeTypeRef();
        return ref.substring(ref.indexOf(":") + 1);
    }
}

