/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ect.formats.unedifact;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.milyn.ect.EdiParseException;
import org.milyn.ect.common.XmlTagEncoder;
import org.milyn.edisax.model.internal.Component;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.model.internal.SegmentGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnEdifactDefinitionReader {
    private static final String DATA_ELEMENT_PREFIX = "e";
    private static final String ELEMENT_SEPARATOR = "^-+$";
    private static final String DOTS = "\\.\\.";
    private static final Pattern WHOLE_DATA_ELEMENT = Pattern.compile(" *(\\d{3})*[SX\\|\\+\\-\\*\\# ]*(\\d{4}) *(.*) *.*(C|M) *(an|n|a)(\\.*)(\\d*)");
    private static final Pattern FIRST_DATA_ELEMENT_PART = Pattern.compile(" *(\\d{3})*[SX\\|\\+\\-\\*\\# ]*(\\d{4}) *(.*) *");
    private static final Pattern SECOND_DATA_ELEMENT_PART = Pattern.compile(" *(.*) *.*(C|M) *(an|n|a)(\\.*)(\\d*)");
    private static final Pattern ELEMENT_HEADER = Pattern.compile("[SX\\|\\+\\-\\*\\# ]*(\\w{4}) *(.*) *\\[(\\w)\\]");
    private static final Pattern ELEMENT_HEADER_OLD = Pattern.compile("[SX\\|\\+\\-\\*\\# ]*(\\w{4}) *(.*)");
    private static final Pattern COMPOSITE_HEADER = Pattern.compile("[SX\\|\\+\\-\\*\\# ]*(\\w{4}) *(.*)");
    private static final Pattern SEGMENT_HEADER = Pattern.compile("[SX\\|\\+\\-\\*\\# ]*(\\w{3}) *(.*)");
    private static final Pattern SEGMENT_ELEMENT = Pattern.compile(" *\\** *(\\d{3})*[SX\\|\\+\\-\\*\\# ]*(\\d{4}|C\\d{3}) *(.*) *( C| M).*");
    private static final Pattern FIRST_SEGMENT_ELEMENT = Pattern.compile(" *(\\d{3})*[SX\\|\\+\\-\\*\\# ]*(\\d{4}|C\\d{3}) *(.*)");
    private static final Pattern SECOND_SEGMENT_ELEMENT = Pattern.compile("^(.*) *( C| M).*");

    private static List<Segment> readSegments(Reader reader, Map<String, Field> composites, Map<String, Component> datas, boolean useShortName) throws IOException, EdiParseException {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        BufferedReader _reader = new BufferedReader(reader);
        UnEdifactDefinitionReader.moveToNextPart(_reader);
        Segment segment = UnEdifactDefinitionReader.getSegment(_reader, composites, datas, useShortName);
        while (segment != null) {
            segments.add(segment);
            segment = UnEdifactDefinitionReader.getSegment(_reader, composites, datas, useShortName);
        }
        return segments;
    }

    private static Segment getSegment(BufferedReader reader, Map<String, Field> fields, Map<String, Component> componens, boolean useShortName) throws IOException, EdiParseException {
        String line = UnEdifactDefinitionReader.readUntilValue(reader);
        if (line == null) {
            return null;
        }
        Matcher headerMatcher = SEGMENT_HEADER.matcher(line);
        if (!headerMatcher.matches()) {
            throw new EdiParseException("Unable to extract segment code and name for Segment from line [" + line + "].");
        }
        String segcode = headerMatcher.group(1);
        String name = headerMatcher.group(2);
        String description = UnEdifactDefinitionReader.getValue(reader, "Function:");
        Segment segment = new Segment();
        segment.setSegcode(segcode);
        segment.setName(name);
        if (useShortName) {
            segment.setXmltag(XmlTagEncoder.encode(segcode.trim()));
        } else {
            segment.setXmltag(XmlTagEncoder.encode(name.trim()));
        }
        segment.setDescription(description);
        segment.setTruncatable(Boolean.valueOf(true));
        line = UnEdifactDefinitionReader.readUntilValue(reader);
        while (line != null && !line.matches(ELEMENT_SEPARATOR)) {
            Matcher matcher = SEGMENT_ELEMENT.matcher(line);
            if (matcher.matches()) {
                UnEdifactDefinitionReader.addFieldToSegment(fields, componens, segment, matcher.group(2), matcher.group(4).trim().equalsIgnoreCase("M"));
                if (matcher.group(2).startsWith("C")) {
                    while (line != null && !line.equals("")) {
                        line = reader.readLine();
                    }
                }
            } else {
                matcher = FIRST_SEGMENT_ELEMENT.matcher(line);
                if (matcher.matches()) {
                    String id = matcher.group(2);
                    line = reader.readLine();
                    if (line == null) continue;
                    matcher = SECOND_SEGMENT_ELEMENT.matcher(line);
                    if (matcher.matches()) {
                        UnEdifactDefinitionReader.addFieldToSegment(fields, componens, segment, id, matcher.group(2).trim().equalsIgnoreCase("M"));
                    }
                }
            }
            line = reader.readLine();
        }
        return segment;
    }

    private static void addFieldToSegment(Map<String, Field> fields, Map<String, Component> componens, Segment segment, String id, boolean isMandatory) {
        if (id.toUpperCase().startsWith("C")) {
            segment.getFields().add(UnEdifactDefinitionReader.copyField(fields.get(id), isMandatory));
        } else {
            segment.getFields().add(UnEdifactDefinitionReader.convertToField(componens.get(id), isMandatory));
        }
    }

    private static Field convertToField(Component component, boolean isMandatory) {
        Field field = new Field();
        field.setName(component.getName());
        field.setXmltag(XmlTagEncoder.encode(component.getXmltag()));
        field.setNodeTypeRef(component.getNodeTypeRef());
        field.setDocumentation(component.getDocumentation());
        field.setMaxLength(component.getMaxLength());
        field.setMinLength(component.getMinLength());
        field.setRequired(Boolean.valueOf(isMandatory));
        field.setTruncatable(Boolean.valueOf(true));
        field.setDataType(component.getDataType());
        field.setDataTypeParameters(component.getTypeParameters());
        return field;
    }

    private static Field copyField(Field oldField, boolean isMandatory) {
        Field field = new Field();
        field.setName(oldField.getName());
        field.setXmltag(XmlTagEncoder.encode(oldField.getXmltag()));
        field.setNodeTypeRef(oldField.getNodeTypeRef());
        field.setDocumentation(oldField.getDocumentation());
        field.setMaxLength(oldField.getMaxLength());
        field.setMinLength(oldField.getMinLength());
        field.setRequired(Boolean.valueOf(isMandatory));
        field.setTruncatable(Boolean.valueOf(true));
        field.setDataType(oldField.getDataType());
        field.setDataTypeParameters(oldField.getTypeParameters());
        field.getComponents().addAll(oldField.getComponents());
        return field;
    }

    private static Map<String, Field> readFields(Reader reader, Map<String, Component> components, boolean useShortName) throws IOException, EdiParseException {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        BufferedReader _reader = new BufferedReader(reader);
        UnEdifactDefinitionReader.moveToNextPart(_reader);
        Field field = new Field();
        String id = UnEdifactDefinitionReader.populateField(_reader, components, field, useShortName);
        while (id != null) {
            fields.put(id, field);
            UnEdifactDefinitionReader.moveToNextPart(_reader);
            field = new Field();
            id = UnEdifactDefinitionReader.populateField(_reader, components, field, useShortName);
        }
        return fields;
    }

    private static String populateField(BufferedReader reader, Map<String, Component> components, Field field, boolean useShortName) throws IOException, EdiParseException {
        String line = UnEdifactDefinitionReader.readUntilValue(reader);
        if (line == null) {
            return null;
        }
        Matcher headerMatcher = COMPOSITE_HEADER.matcher(line);
        if (!headerMatcher.matches()) {
            throw new EdiParseException("Unable to extract id and name for Composite element from line [" + line + "].");
        }
        String id = headerMatcher.group(1);
        String name = headerMatcher.group(2);
        String description = UnEdifactDefinitionReader.getValue(reader, "Desc:");
        field.setName(name);
        field.setNodeTypeRef(id);
        if (useShortName) {
            field.setXmltag(XmlTagEncoder.encode(id));
        } else {
            field.setXmltag(XmlTagEncoder.encode(name));
        }
        field.setDocumentation(description);
        line = UnEdifactDefinitionReader.readUntilValue(reader);
        while (line != null && line.length() != 0) {
            LinePart linePart = UnEdifactDefinitionReader.getLinePart(reader, line);
            if (linePart != null) {
                Component component = new Component();
                component.setRequired(Boolean.valueOf(linePart.isMandatory()));
                UnEdifactDefinitionReader.populateComponent(component, components.get(linePart.getId()));
                field.getComponents().add(component);
            }
            line = reader.readLine();
        }
        return id;
    }

    private static void populateComponent(Component toComponent, Component fromComponent) {
        toComponent.setDocumentation(fromComponent.getDocumentation());
        toComponent.setMaxLength(fromComponent.getMaxLength());
        toComponent.setMinLength(fromComponent.getMinLength());
        toComponent.setTruncatable(Boolean.valueOf(true));
        toComponent.setDataType(fromComponent.getDataType());
        toComponent.setDataTypeParameters(fromComponent.getTypeParameters());
        toComponent.setXmltag(XmlTagEncoder.encode(fromComponent.getXmltag()));
        toComponent.setName(fromComponent.getName());
    }

    private static Map<String, Component> readComponents(Reader reader, boolean useShortName) throws IOException, EdiParseException {
        HashMap<String, Component> datas = new HashMap<String, Component>();
        BufferedReader _reader = new BufferedReader(reader);
        UnEdifactDefinitionReader.moveToNextPart(_reader);
        Component component = new Component();
        String id = UnEdifactDefinitionReader.populateComponent(_reader, component, useShortName);
        while (id != null) {
            datas.put(id, component);
            UnEdifactDefinitionReader.moveToNextPart(_reader);
            component = new Component();
            id = UnEdifactDefinitionReader.populateComponent(_reader, component, useShortName);
        }
        return datas;
    }

    private static String populateComponent(BufferedReader reader, Component component, boolean useShortName) throws IOException, EdiParseException {
        String name;
        String id;
        String line = UnEdifactDefinitionReader.readUntilValue(reader);
        if (line == null) {
            return null;
        }
        Matcher headerMatcher = ELEMENT_HEADER.matcher(line);
        if (headerMatcher.matches()) {
            id = headerMatcher.group(1);
            name = headerMatcher.group(2);
        } else {
            Matcher headerMatcherOld = ELEMENT_HEADER_OLD.matcher(line);
            if (headerMatcherOld.matches()) {
                id = headerMatcherOld.group(1);
                name = headerMatcherOld.group(2);
            } else {
                throw new EdiParseException("Unable to extract id and name for Data element from line [" + line + "].");
            }
        }
        String description = UnEdifactDefinitionReader.getValue(reader, "Desc:");
        String repr = UnEdifactDefinitionReader.getValue(reader, "Repr:");
        String[] typeAndOccurance = repr.split(DOTS);
        component.setName(name);
        component.setNodeTypeRef(id);
        if (useShortName) {
            component.setXmltag(XmlTagEncoder.encode((DATA_ELEMENT_PREFIX + id).trim()));
        } else {
            component.setXmltag(XmlTagEncoder.encode(name.trim()));
        }
        component.setDataType(UnEdifactDefinitionReader.getType(typeAndOccurance));
        component.setMinLength(Integer.valueOf(UnEdifactDefinitionReader.getMinLength(typeAndOccurance)));
        component.setMaxLength(Integer.valueOf(UnEdifactDefinitionReader.getMaxLength(typeAndOccurance)));
        component.setDocumentation(description);
        return id;
    }

    private static int getMinLength(String[] typeAndOccurance) {
        if (typeAndOccurance.length == 0) {
            return 0;
        }
        if (typeAndOccurance.length == 1) {
            return Integer.valueOf(typeAndOccurance[0].trim().replace("a", "").replace("n", ""));
        }
        return 0;
    }

    private static int getMaxLength(String[] typeAndOccurance) {
        if (typeAndOccurance.length == 0) {
            return 0;
        }
        if (typeAndOccurance.length == 1) {
            return Integer.valueOf(typeAndOccurance[0].trim().replace("a", "").replace("n", ""));
        }
        return Integer.valueOf(typeAndOccurance[1].trim());
    }

    private static String getType(String[] typeAndOccurance) {
        if (typeAndOccurance.length == 0) {
            return "String";
        }
        if (typeAndOccurance[0].trim().equals("n")) {
            return "DABigDecimal";
        }
        return "String";
    }

    private static String getValue(BufferedReader reader, String prefix) throws IOException {
        String line;
        StringBuilder result = new StringBuilder();
        while ((line = UnEdifactDefinitionReader.readUntilValue(reader)) != null) {
            if (!(line = line.replace("|", "").trim()).startsWith(prefix)) continue;
            result.append(line.replace(prefix, ""));
            line = reader.readLine();
            while (line != null && line.trim().length() != 0) {
                result.append(line.trim());
                line = reader.readLine();
            }
            break block0;
        }
        return result.toString();
    }

    private static String readUntilValue(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        while (line != null && line.length() == 0) {
            line = reader.readLine();
        }
        return line;
    }

    private static void moveToNextPart(BufferedReader reader) throws IOException {
        String currentLine = "";
        while (currentLine != null && !currentLine.matches(ELEMENT_SEPARATOR)) {
            currentLine = reader.readLine();
        }
    }

    private static LinePart getLinePart(BufferedReader reader, String line) throws IOException {
        LinePart part = null;
        Matcher matcher = WHOLE_DATA_ELEMENT.matcher(line);
        if (matcher.matches()) {
            part = new LinePart(matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5), matcher.group(6), matcher.group(7));
        } else {
            matcher = FIRST_DATA_ELEMENT_PART.matcher(line);
            if (matcher.matches()) {
                part = new LinePart(matcher.group(2), matcher.group(3));
                line = reader.readLine();
                matcher = SECOND_DATA_ELEMENT_PART.matcher(line);
                if (matcher.matches()) {
                    part.setDescription(part.getDescription() + " " + matcher.group(1));
                    part.setMandatory(matcher.group(2));
                    part.setType(matcher.group(3));
                    part.setMinOccurance(matcher.group(4), matcher.group(5));
                    part.setMaxOccurance(matcher.group(5));
                }
            }
        }
        return part;
    }

    public static Edimap parse(Reader dataReader, Reader compositeReader, Reader segmentReader, boolean useShortName) throws IOException, EdiParseException {
        Map<String, Component> datas = UnEdifactDefinitionReader.readComponents(dataReader, useShortName);
        Map<String, Field> composites = UnEdifactDefinitionReader.readFields(compositeReader, datas, useShortName);
        List<Segment> segments = UnEdifactDefinitionReader.readSegments(segmentReader, composites, datas, useShortName);
        Edimap edimap = new Edimap();
        edimap.setSegments(new SegmentGroup());
        edimap.getSegments().getSegments().addAll(segments);
        return edimap;
    }

    private static class LinePart {
        private String id;
        private String description;
        private String type;
        private Integer minOccurance;
        private Integer maxOccurance;
        private boolean isMandatory;

        public LinePart(String id, String description, String mandatory, String type, String minOccurs, String maxOccurs) {
            this.id = id;
            this.description = description;
            this.setMandatory(mandatory);
            this.setType(type);
            this.setMinOccurance(minOccurs, maxOccurs);
            this.setMaxOccurance(maxOccurs);
        }

        private void setMandatory(String mandatory) {
            this.isMandatory = mandatory.equalsIgnoreCase("M");
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setMaxOccurance(String maxOccurs) {
            this.maxOccurance = Integer.valueOf(maxOccurs);
        }

        public void setMinOccurance(String minOccurs, String maxOccurs) {
            this.minOccurance = minOccurs.equals("..") ? 0 : Integer.valueOf(maxOccurs);
        }

        public void setType(String type) {
            this.type = type.equalsIgnoreCase("n") ? "DABigDecimal" : "String";
        }

        public LinePart(String id, String description) {
            this.id = id;
            this.description = description;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public String getType() {
            return this.type;
        }

        public Integer getMinOccurance() {
            return this.minOccurance;
        }

        public Integer getMaxOccurance() {
            return this.maxOccurance;
        }

        public boolean isMandatory() {
            return this.isMandatory;
        }
    }
}

