/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ect;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.milyn.ect.EdiConvertionTool;
import org.milyn.ect.EdiParseException;

public class ECTUnEdifactExecutor {
    private File unEdifactZip;
    private String urn;
    private File mappingModelZip;
    private File mappingModelFolder;
    private boolean useShortName = true;

    public void execute() throws EdiParseException {
        ZipInputStream definitionZipStream;
        this.assertConfigOK();
        try {
            definitionZipStream = new ZipInputStream(new FileInputStream(this.unEdifactZip));
        }
        catch (FileNotFoundException e) {
            throw new EdiParseException("Error opening zip file containing the Un/Edifact specification '" + this.unEdifactZip.getAbsoluteFile() + "'.", e);
        }
        try {
            if (this.mappingModelZip != null) {
                EdiConvertionTool.fromUnEdifactSpec(definitionZipStream, new ZipOutputStream(new FileOutputStream(this.mappingModelZip)), this.urn, this.useShortName);
            } else {
                EdiConvertionTool.fromUnEdifactSpec(definitionZipStream, this.mappingModelFolder, this.urn, this.useShortName);
            }
        }
        catch (Exception e) {
            throw new EdiParseException("Error parsing the Un/Edifact specification '" + this.unEdifactZip.getAbsoluteFile() + "'.", e);
        }
    }

    private void assertConfigOK() {
        if (this.unEdifactZip == null) {
            throw new EdiParseException("Mandatory UN/EDIFACT ECT property 'unEdifactZip' + not specified.");
        }
        if (this.urn == null) {
            throw new EdiParseException("Mandatory UN/EDIFACT ECT property 'urn' + not specified.");
        }
        if (this.mappingModelZip == null && this.mappingModelFolder == null) {
            throw new EdiParseException("One of the properties 'mappingModelZip' or 'mappingModelFolder' must be specified on the UN/EDIFACT ECT configuration.");
        }
        if (this.mappingModelZip != null && this.mappingModelFolder != null) {
            throw new EdiParseException("Only one of the properties 'mappingModelZip' and 'mappingModelFolder' should be specified on the UN/EDIFACT ECT configuration.");
        }
        if (!this.unEdifactZip.exists()) {
            throw new EdiParseException("Specified UN/EDIFACT definition zip file '" + this.unEdifactZip.getAbsoluteFile() + "' does not exist.");
        }
        if (this.unEdifactZip.isDirectory()) {
            throw new EdiParseException("Specified UN/EDIFACT definition zip file '" + this.unEdifactZip.getAbsoluteFile() + "' exists, but is a directory.  Must be a zip file.");
        }
        if (this.mappingModelZip != null && this.mappingModelZip.exists()) {
            throw new EdiParseException("Specified mapping model zip file '" + this.mappingModelZip.getAbsoluteFile() + "' already exists.");
        }
    }

    public void setUnEdifactZip(File unEdifactZip) {
        this.unEdifactZip = unEdifactZip;
    }

    public void setUrn(String urn) {
        this.urn = urn;
    }

    public void setMappingModelZip(File mappingModelZip) {
        this.mappingModelZip = mappingModelZip;
    }

    public void setMappingModelFolder(File mappingModelFolder) {
        this.mappingModelFolder = mappingModelFolder;
    }

    public void setUseShortName(boolean useShortName) {
        this.useShortName = useShortName;
    }
}

