/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ect.ecore;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.milyn.archive.Archive;
import org.milyn.ect.ecore.CustomSchemaBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaConverter {
    public static final SchemaConverter INSTANCE = new SchemaConverter();
    public static final String FRAGMENT_XML_ENTRY = "fragment.xml";
    private static final SimpleDateFormat qualifierFormat = new SimpleDateFormat("yyyyMMdd-HHmm");
    private static final Log log = LogFactory.getLog(SchemaConverter.class);

    protected SchemaConverter() {
    }

    public Archive createArchive(Set<EPackage> packages, String pluginID, String pathPrefix) throws IOException {
        String qualifier = qualifierFormat.format(Calendar.getInstance().getTime());
        Archive archive = new Archive(pluginID + "_1.0.0.v" + qualifier + ".jar");
        StringBuilder pluginBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?eclipse version=\"3.0\"?>\n<plugin>\n");
        StringBuilder xmlExtension = new StringBuilder("\t<extension point=\"org.eclipse.wst.xml.core.catalogContributions\"><catalogContribution>\n");
        for (EPackage pkg : packages) {
            ResourceSet rs = this.createResourceSet();
            Resource resource = this.addSchemaResource(rs, pkg);
            EObject obj = (EObject)resource.getContents().get(0);
            String fileName = resource.getURI().lastSegment();
            String ecoreEntryPath = pathPrefix + "/" + fileName;
            xmlExtension.append(this.saveSchema(archive, ecoreEntryPath, resource, ((XSDSchema)obj).getTargetNamespace(), pluginID));
            System.gc();
        }
        xmlExtension.append("\t</catalogContribution></extension>\n");
        pluginBuilder.append((CharSequence)xmlExtension);
        pluginBuilder.append("</plugin>");
        archive.addEntry(FRAGMENT_XML_ENTRY, pluginBuilder.toString());
        return archive;
    }

    private Resource addSchemaResource(ResourceSet rs, EPackage pkg) {
        String message = pkg.getName();
        log.debug((Object)(pkg.getName() + " schema generation start"));
        Resource xsd = null;
        long start = System.currentTimeMillis();
        try {
            CustomSchemaBuilder schemaBuilder = new CustomSchemaBuilder(ExtendedMetaData.INSTANCE);
            XSDSchema schema = schemaBuilder.getSchema(pkg);
            xsd = rs.createResource(URI.createFileURI((String)(message + ".xsd")));
            if (!xsd.getContents().isEmpty()) {
                throw new RuntimeException("Duplicate schema " + xsd.getURI());
            }
            xsd.getContents().add((Object)schema);
        }
        catch (Exception e) {
            log.error((Object)("Failed to generate schema for " + pkg.getNsURI()), (Throwable)e);
        }
        log.info((Object)(pkg.getName() + " schema generation took " + (float)(System.currentTimeMillis() - start) / 1000.0f + " sec."));
        return xsd;
    }

    private String saveSchema(Archive archive, String entryPath, Resource resource, String ns, String pluginID) {
        StringBuilder result = new StringBuilder();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        log.info((Object)("Saving XML Schema " + ns));
        try {
            resource.save((OutputStream)out, null);
            if (archive.getEntries().containsKey(entryPath)) {
                throw new RuntimeException("Duplicate entry " + entryPath);
            }
            archive.addEntry(entryPath, out.toByteArray());
            result.append("\t<uri name=\"");
            result.append(ns);
            result.append("\" uri=\"platform:/fragment/" + pluginID + "/");
            result.append(entryPath);
            result.append("\"/>\n");
        }
        catch (Exception e) {
            log.error((Object)("Failed to save XML Schema " + ns), (Throwable)e);
        }
        return result.toString();
    }

    private ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        return resourceSet;
    }

    public void convertEDIMap(EPackage pkg, OutputStream out) throws IOException {
        ResourceSet rs = this.createResourceSet();
        Resource resource = this.addSchemaResource(rs, pkg);
        resource.save(out, null);
        resource = null;
        System.gc();
    }
}

