/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ect.formats.unedifact;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.ect.EdiConvertionTool;
import org.milyn.ect.EdiParseException;
import org.milyn.ect.EdiSpecificationReader;
import org.milyn.ect.formats.unedifact.UnEdifactDefinitionReader;
import org.milyn.ect.formats.unedifact.UnEdifactMessage;
import org.milyn.edisax.interchange.EdiDirectory;
import org.milyn.edisax.model.EdifactModel;
import org.milyn.edisax.model.internal.Description;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.unedifact.UNEdifactInterchangeParser;
import org.milyn.edisax.util.EDIUtils;
import org.milyn.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnEdifactSpecificationReader
implements EdiSpecificationReader {
    private static final Log logger = LogFactory.getLog(UnEdifactSpecificationReader.class);
    public static final String INTERCHANGE_TYPE = "UNEDIFACT";
    private static final int BUFFER = 2048;
    private static final String INTERCHANGE_DEFINITION = "un-edifact-interchange-definition.xml";
    private static final String INTERCHANGE_DEFINITION_SHORTNAME = "un-edifact-interchange-definition-shortname.xml";
    private boolean useImport;
    private boolean useShortName;
    private Map<String, byte[]> definitionFiles;
    private Map<String, byte[]> messageFiles;
    private Edimap definitionModel;
    private Set<String> versions = new HashSet<String>();
    private Set<String> messages = new HashSet<String>();
    private EdiDirectory ediDirectory;
    private Pattern entryFileName = Pattern.compile("^([A-Z]+)_([A-Z])\\.([0-9]+[A-Z])$");

    public UnEdifactSpecificationReader(ZipInputStream specificationInStream, boolean useImport) throws IOException {
        this(specificationInStream, useImport, true);
    }

    public UnEdifactSpecificationReader(ZipInputStream specificationInStream, boolean useImport, boolean useShortName) throws IOException {
        this.useImport = useImport;
        this.useShortName = useShortName;
        this.definitionFiles = new HashMap<String, byte[]>();
        this.messageFiles = new HashMap<String, byte[]>();
        this.readDefinitionEntries(specificationInStream, new ZipDirectoryEntry("eded.", this.definitionFiles), new ZipDirectoryEntry("edcd.", this.definitionFiles), new ZipDirectoryEntry("edsd.", this.definitionFiles), new ZipDirectoryEntry("edmd.", "*", this.messageFiles));
        if (this.versions.size() != 1) {
            if (this.versions.size() == 0) {
                throw new EdiParseException("Seems that we have a directory containing 0 parseable version inside: " + this.versions + ".\n All messages:\n\t" + this.messages);
            }
            throw new EdiParseException("Seems that we have a directory containing more than one parseable version inside: " + this.versions + ".\n All messages:\n\t" + this.messages);
        }
        String version = this.versions.iterator().next();
        this.definitionModel = this.parseEDIDefinitionFiles();
        this.addMissingDefinitions(this.definitionModel);
        this.definitionModel.getDescription().setNamespace("urn:org.milyn.edi.unedifact:un:" + version + ":common");
        try {
            String interchangeSegmentDefinitions = INTERCHANGE_DEFINITION_SHORTNAME;
            if (!useShortName) {
                interchangeSegmentDefinitions = INTERCHANGE_DEFINITION;
            }
            EdifactModel interchangeEnvelope = new EdifactModel(ClassUtil.getResourceAsStream((String)interchangeSegmentDefinitions, this.getClass()));
            this.definitionModel.getSegments().getSegments().addAll(interchangeEnvelope.getEdimap().getSegments().getSegments());
        }
        catch (Exception e) {
            throw new EdiParseException(e.getMessage(), e);
        }
    }

    @Override
    public Set<String> getMessageNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        names.add(this.definitionModel.getDescription().getName());
        names.addAll(this.messageFiles.keySet());
        return names;
    }

    @Override
    public Edimap getMappingModel(String messageName) throws IOException {
        if (messageName.equals(this.definitionModel.getDescription().getName())) {
            return this.definitionModel;
        }
        return this.parseEdiMessage(messageName).getEdimap();
    }

    @Override
    public Properties getInterchangeProperties() {
        Properties properties = new Properties();
        properties.setProperty("interchangeType", INTERCHANGE_TYPE);
        properties.setProperty("messageBindingConfig", "/org/milyn/smooks/edi/unedifact/model/r41/bindings/unedifact-message.xml");
        properties.setProperty("interchangeBindingConfig", "/org/milyn/smooks/edi/unedifact/model/r41/bindings/unedifact-interchange.xml");
        return properties;
    }

    @Override
    public EdiDirectory getEdiDirectory(String ... includeMessages) throws IOException {
        if (this.ediDirectory == null) {
            HashSet<String> includeMessageSet = null;
            String commonMessageName = this.getCommmonMessageName();
            Set<String> messages = this.getMessageNames();
            Edimap commonModel = null;
            ArrayList<Edimap> models = new ArrayList<Edimap>();
            if (includeMessages != null && includeMessages.length > 0) {
                includeMessageSet = new HashSet<String>(Arrays.asList(includeMessages));
            }
            for (String message : messages) {
                if (includeMessageSet != null && !message.equals(commonMessageName) && !includeMessageSet.contains(message)) continue;
                Edimap model = this.getMappingModel(message);
                EdiConvertionTool.removeDuplicateSegments(model.getSegments());
                if (message.equals(commonMessageName)) {
                    if (commonModel == null) {
                        commonModel = model;
                        continue;
                    }
                    logger.warn((Object)("Common model message '" + commonMessageName + "' already read."));
                    continue;
                }
                models.add(model);
            }
            this.ediDirectory = new EdiDirectory(commonModel, models);
        }
        return this.ediDirectory;
    }

    private String getCommmonMessageName() {
        return EDIUtils.MODEL_SET_DEFINITIONS_DESCRIPTION.getName();
    }

    private void addMissingDefinitions(Edimap definitionModel) {
        Segment ugh = new Segment();
        Segment ugt = new Segment();
        ugh.setSegcode("UGH");
        ugh.setXmltag("UGH");
        ugh.addField(new Field("id", "urn:org.milyn.edi.unedifact.v41", Boolean.valueOf(true)));
        ugt.setSegcode("UGT");
        ugt.setXmltag("UGT");
        ugt.addField(new Field("id", "urn:org.milyn.edi.unedifact.v41", Boolean.valueOf(true)));
        definitionModel.getSegments().getSegments().add(ugh);
        definitionModel.getSegments().getSegments().add(ugt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnEdifactMessage parseEdiMessage(String messageName) throws IOException {
        byte[] message = this.messageFiles.get(messageName);
        if (message != null) {
            InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(message));
            try {
                UnEdifactMessage unEdifactMessage = new UnEdifactMessage(reader, this.useImport, this.useShortName, this.definitionModel);
                return unEdifactMessage;
            }
            finally {
                reader.close();
            }
        }
        return null;
    }

    public Edimap getDefinitionModel() throws IOException {
        return this.definitionModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Edimap parseEDIDefinitionFiles() throws IOException, EdiParseException {
        Edimap edifactModel;
        Reader dataISR = null;
        Reader compositeISR = null;
        Reader segmentISR = null;
        try {
            dataISR = new InputStreamReader(new ByteArrayInputStream(this.definitionFiles.get("eded.")));
            compositeISR = new InputStreamReader(new ByteArrayInputStream(this.definitionFiles.get("edcd.")));
            segmentISR = new InputStreamReader(new ByteArrayInputStream(this.definitionFiles.get("edsd.")));
            edifactModel = UnEdifactDefinitionReader.parse(dataISR, compositeISR, segmentISR, this.useShortName);
            edifactModel.setDescription((Description)EDIUtils.MODEL_SET_DEFINITIONS_DESCRIPTION.clone());
            edifactModel.getSegments().setXmltag("DefinitionMap");
            edifactModel.setDelimiters(UNEdifactInterchangeParser.defaultUNEdifactDelimiters);
        }
        finally {
            if (dataISR != null) {
                dataISR.close();
            }
            if (compositeISR != null) {
                compositeISR.close();
            }
            if (segmentISR != null) {
                segmentISR.close();
            }
        }
        return edifactModel;
    }

    private void readDefinitionEntries(ZipInputStream folderZip, ZipDirectoryEntry ... entries) throws IOException {
        ZipEntry fileEntry = folderZip.getNextEntry();
        while (fileEntry != null) {
            String fName = new File(fileEntry.getName().toLowerCase()).getName().replaceFirst("tr", "ed");
            for (ZipDirectoryEntry entry : entries) {
                int size;
                if (!fName.startsWith(entry.getDirectory())) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[2048];
                while ((size = folderZip.read(bytes, 0, bytes.length)) != -1) {
                    baos.write(bytes, 0, size);
                }
                ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(baos.toByteArray()));
                this.readZipEntry(entry.getEntries(), zipInputStream, entry.getFile());
                zipInputStream.close();
            }
            folderZip.closeEntry();
            fileEntry = folderZip.getNextEntry();
        }
    }

    private boolean readZipEntry(Map<String, byte[]> files, ZipInputStream folderZip, String entry) throws IOException {
        boolean result = false;
        ZipEntry fileEntry = folderZip.getNextEntry();
        while (fileEntry != null) {
            String fileName = fileEntry.getName();
            String fName = new File(fileName.toLowerCase()).getName().replaceFirst("tr", "ed");
            if (fName.startsWith(entry) || entry.equals("*")) {
                int size;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[2048];
                while ((size = folderZip.read(bytes, 0, bytes.length)) != -1) {
                    UnEdifactSpecificationReader.translatePseudoGraph(bytes);
                    baos.write(bytes, 0, size);
                }
                File file = new File(fileName);
                String messageName = file.getName().toUpperCase();
                result = true;
                this.messages.add(messageName);
                if (entry.equals("*")) {
                    Matcher match = this.entryFileName.matcher(messageName);
                    if (match.matches()) {
                        String entryName = match.group(1);
                        files.put(entryName, baos.toByteArray());
                        this.versions.add((match.group(2) + match.group(3)).toLowerCase());
                    }
                } else {
                    files.put(entry, baos.toByteArray());
                    break;
                }
            }
            folderZip.closeEntry();
            fileEntry = folderZip.getNextEntry();
        }
        return result;
    }

    private static void translatePseudoGraph(byte[] bytes) {
        int l = bytes.length;
        block5: for (int i = 0; i < l; ++i) {
            switch (bytes[i]) {
                case -60: {
                    bytes[i] = 45;
                    continue block5;
                }
                case -65: 
                case -63: 
                case -39: {
                    bytes[i] = 43;
                    continue block5;
                }
                case -77: {
                    bytes[i] = 124;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ZipDirectoryEntry {
        private String directory;
        private String file;
        private Map<String, byte[]> entries;

        private ZipDirectoryEntry(String directory, Map<String, byte[]> entries) {
            this(directory, directory, entries);
        }

        public ZipDirectoryEntry(String directory, String file, Map<String, byte[]> entries) {
            this.directory = directory;
            this.file = file;
            this.entries = entries;
        }

        public String getDirectory() {
            return this.directory;
        }

        public String getFile() {
            return this.file;
        }

        public Map<String, byte[]> getEntries() {
            return this.entries;
        }
    }
}

