/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.dynamic.resolvers;

import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.milyn.javabean.dynamic.Descriptor;
import org.milyn.util.ClassUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResolver
implements EntityResolver {
    private List<Properties> descriptors;
    private ClassLoader classLoader = AbstractResolver.class.getClassLoader();

    protected AbstractResolver(List<Properties> descriptors) {
        this.descriptors = descriptors;
    }

    protected List<Properties> getDescriptors() {
        return this.descriptors;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected InputSource resolveSchemaLocation(String systemId) throws SAXException {
        String namespaceId = Descriptor.getNamespaceId(systemId, this.descriptors);
        if (namespaceId != null) {
            String schemaLocation = Descriptor.getSchemaLocation(namespaceId, this.descriptors);
            if (schemaLocation == null) {
                throw new SAXException("Failed to resolve schemaLocation for namespace '" + systemId + "'.");
            }
            InputStream stream = ClassUtil.getResourceAsStream((String)schemaLocation, (ClassLoader)this.classLoader);
            if (stream == null) {
                throw new SAXException("schemaLocation '" + schemaLocation + "' for namespace '" + systemId + "' does not resolve to a Classpath resource.");
            }
            return new InputSource(stream);
        }
        return null;
    }

    protected InputSource resolveBindingConfigLocation(String systemId) throws SAXException {
        String namespaceId = Descriptor.getNamespaceId(systemId, this.descriptors);
        if (namespaceId != null) {
            String bindingConfigLocation = Descriptor.getBindingConfigLocation(namespaceId, this.descriptors);
            if (bindingConfigLocation == null) {
                throw new SAXException("Failed to resolve bindingConfigLocation for namespace '" + systemId + "'.");
            }
            InputStream stream = ClassUtil.getResourceAsStream((String)bindingConfigLocation, (ClassLoader)this.classLoader);
            if (stream == null) {
                throw new SAXException("bindingConfigLocation '" + bindingConfigLocation + "' for namespace '" + systemId + "' does not resolve to a Classpath resource.");
            }
            return new InputSource(stream);
        }
        return null;
    }
}

