/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.scribe.invoker;

import org.milyn.annotation.AnnotatedClass;
import org.milyn.annotation.AnnotationManager;
import org.milyn.assertion.AssertArgument;
import org.milyn.scribe.Dao;
import org.milyn.scribe.Flushable;
import org.milyn.scribe.Locator;
import org.milyn.scribe.MappingDao;
import org.milyn.scribe.ObjectStore;
import org.milyn.scribe.Queryable;
import org.milyn.scribe.invoker.AnnotatedDaoInvoker;
import org.milyn.scribe.invoker.DaoInvoker;
import org.milyn.scribe.invoker.InterfaceDaoInvoker;
import org.milyn.scribe.reflection.AnnotatedDaoRuntimeInfoFactory;

public class DaoInvokerFactory {
    private static final DaoInvokerFactory instance = new DaoInvokerFactory();
    public static final String REPOSITORY_KEY = DaoInvokerFactory.class.getName() + "#REPOSITORY_KEY";

    public static final DaoInvokerFactory getInstance() {
        return instance;
    }

    private DaoInvokerFactory() {
    }

    public DaoInvoker create(Object dao, ObjectStore objectStore) {
        AssertArgument.isNotNull(dao, "dao");
        AssertArgument.isNotNull(objectStore, "objectStore");
        if (dao instanceof Dao || dao instanceof MappingDao || dao instanceof Queryable || dao instanceof Locator || dao instanceof Flushable) {
            return new InterfaceDaoInvoker(dao);
        }
        AnnotatedClass annotatedClass = AnnotationManager.getAnnotatedClass(dao.getClass());
        if (annotatedClass.isAnnotationPresent(org.milyn.scribe.annotation.Dao.class)) {
            AnnotatedDaoRuntimeInfoFactory repository = this.getAnnotatedDAORuntimeInfoRepository(objectStore);
            return new AnnotatedDaoInvoker(dao, repository.create(dao.getClass()));
        }
        throw new IllegalArgumentException("The DAO object doesn't implement any of the DAO interfaces or is annotated with the [" + org.milyn.scribe.annotation.Dao.class.getName() + "] annotation");
    }

    private AnnotatedDaoRuntimeInfoFactory getAnnotatedDAORuntimeInfoRepository(ObjectStore objectStore) {
        AnnotatedDaoRuntimeInfoFactory repository = (AnnotatedDaoRuntimeInfoFactory)objectStore.get(REPOSITORY_KEY);
        if (repository == null) {
            repository = new AnnotatedDaoRuntimeInfoFactory();
            objectStore.set(REPOSITORY_KEY, repository);
        }
        return repository;
    }
}

