/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.repository.impl;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.mitre.oauth2.repository.OAuth2TokenRepository;
import org.mitre.util.jpa.JpaUtil;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JpaOAuth2TokenRepository
implements OAuth2TokenRepository {
    @PersistenceContext
    private EntityManager manager;

    public Set<OAuth2AccessTokenEntity> getAllAccessTokens() {
        TypedQuery query = this.manager.createNamedQuery("OAuth2AccessTokenEntity.getAll", OAuth2AccessTokenEntity.class);
        return new LinkedHashSet<OAuth2AccessTokenEntity>(query.getResultList());
    }

    public Set<OAuth2RefreshTokenEntity> getAllRefreshTokens() {
        TypedQuery query = this.manager.createNamedQuery("OAuth2RefreshTokenEntity.getAll", OAuth2RefreshTokenEntity.class);
        return new LinkedHashSet<OAuth2RefreshTokenEntity>(query.getResultList());
    }

    public OAuth2AccessTokenEntity getAccessTokenByValue(String accessTokenValue) {
        TypedQuery query = this.manager.createNamedQuery("OAuth2AccessTokenEntity.getByTokenValue", OAuth2AccessTokenEntity.class);
        query.setParameter("tokenValue", (Object)accessTokenValue);
        return (OAuth2AccessTokenEntity)JpaUtil.getSingleResult((List)query.getResultList());
    }

    public OAuth2AccessTokenEntity getAccessTokenById(Long id) {
        return (OAuth2AccessTokenEntity)this.manager.find(OAuth2AccessTokenEntity.class, (Object)id);
    }

    @Transactional
    public OAuth2AccessTokenEntity saveAccessToken(OAuth2AccessTokenEntity token) {
        return (OAuth2AccessTokenEntity)JpaUtil.saveOrUpdate((Object)token.getId(), (EntityManager)this.manager, (Object)token);
    }

    @Transactional
    public void removeAccessToken(OAuth2AccessTokenEntity accessToken) {
        OAuth2AccessTokenEntity found = this.getAccessTokenByValue(accessToken.getValue());
        if (found == null) {
            throw new IllegalArgumentException("Access token not found: " + accessToken);
        }
        this.manager.remove((Object)found);
    }

    @Transactional
    public void clearAccessTokensForRefreshToken(OAuth2RefreshTokenEntity refreshToken) {
        TypedQuery query = this.manager.createNamedQuery("OAuth2AccessTokenEntity.getByRefreshToken", OAuth2AccessTokenEntity.class);
        query.setParameter("refreshToken", (Object)refreshToken);
        List accessTokens = query.getResultList();
        for (OAuth2AccessTokenEntity accessToken : accessTokens) {
            this.removeAccessToken(accessToken);
        }
    }

    public OAuth2RefreshTokenEntity getRefreshTokenByValue(String refreshTokenValue) {
        TypedQuery query = this.manager.createNamedQuery("OAuth2RefreshTokenEntity.getByTokenValue", OAuth2RefreshTokenEntity.class);
        query.setParameter("tokenValue", (Object)refreshTokenValue);
        return (OAuth2RefreshTokenEntity)JpaUtil.getSingleResult((List)query.getResultList());
    }

    public OAuth2RefreshTokenEntity getRefreshTokenById(Long id) {
        return (OAuth2RefreshTokenEntity)this.manager.find(OAuth2RefreshTokenEntity.class, (Object)id);
    }

    @Transactional
    public OAuth2RefreshTokenEntity saveRefreshToken(OAuth2RefreshTokenEntity refreshToken) {
        return (OAuth2RefreshTokenEntity)JpaUtil.saveOrUpdate((Object)refreshToken.getId(), (EntityManager)this.manager, (Object)refreshToken);
    }

    @Transactional
    public void removeRefreshToken(OAuth2RefreshTokenEntity refreshToken) {
        OAuth2RefreshTokenEntity found = this.getRefreshTokenByValue(refreshToken.getValue());
        if (found == null) {
            throw new IllegalArgumentException("Refresh token not found: " + refreshToken);
        }
        this.manager.remove((Object)found);
    }

    @Transactional
    public void clearTokensForClient(ClientDetailsEntity client) {
        TypedQuery queryA = this.manager.createNamedQuery("OAuth2AccessTokenEntity.getByClient", OAuth2AccessTokenEntity.class);
        queryA.setParameter("client", (Object)client);
        List accessTokens = queryA.getResultList();
        for (OAuth2AccessTokenEntity accessToken : accessTokens) {
            this.removeAccessToken(accessToken);
        }
        TypedQuery queryR = this.manager.createNamedQuery("OAuth2RefreshTokenEntity.getByClient", OAuth2RefreshTokenEntity.class);
        queryR.setParameter("client", (Object)client);
        List refreshTokens = queryR.getResultList();
        for (OAuth2RefreshTokenEntity refreshToken : refreshTokens) {
            this.removeRefreshToken(refreshToken);
        }
    }

    public List<OAuth2AccessTokenEntity> getAccessTokensForClient(ClientDetailsEntity client) {
        TypedQuery queryA = this.manager.createNamedQuery("OAuth2AccessTokenEntity.getByClient", OAuth2AccessTokenEntity.class);
        queryA.setParameter("client", (Object)client);
        List accessTokens = queryA.getResultList();
        return accessTokens;
    }

    public List<OAuth2RefreshTokenEntity> getRefreshTokensForClient(ClientDetailsEntity client) {
        TypedQuery queryR = this.manager.createNamedQuery("OAuth2RefreshTokenEntity.getByClient", OAuth2RefreshTokenEntity.class);
        queryR.setParameter("client", (Object)client);
        List refreshTokens = queryR.getResultList();
        return refreshTokens;
    }

    public OAuth2AccessTokenEntity getByAuthentication(OAuth2Authentication auth) {
        TypedQuery queryA = this.manager.createNamedQuery("OAuth2AccessTokenEntity.getByAuthentication", OAuth2AccessTokenEntity.class);
        queryA.setParameter("authentication", (Object)auth);
        List accessTokens = queryA.getResultList();
        return (OAuth2AccessTokenEntity)JpaUtil.getSingleResult((List)accessTokens);
    }

    public OAuth2AccessTokenEntity getAccessTokenForIdToken(OAuth2AccessTokenEntity idToken) {
        TypedQuery queryA = this.manager.createNamedQuery("OAuth2AccessTokenEntity.getByIdToken", OAuth2AccessTokenEntity.class);
        queryA.setParameter("idToken", (Object)idToken);
        List accessTokens = queryA.getResultList();
        return (OAuth2AccessTokenEntity)JpaUtil.getSingleResult((List)accessTokens);
    }
}

