/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.filter;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Component(value="promptFilter")
public class PromptFilter
extends GenericFilterBean {
    private Logger logger = LoggerFactory.getLogger(PromptFilter.class);
    public static final String PROMPTED = "PROMPT_FILTER_PROMPTED";
    public static final String PROMPT_REQUESTED = "PROMPT_FILTER_REQUESTED";
    @Autowired
    private OAuth2RequestFactory authRequestFactory;

    /*
     * Enabled aggressive block sorting
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        AuthorizationRequest authRequest = this.authRequestFactory.createAuthorizationRequest(this.createRequestMap(request.getParameterMap()));
        if (authRequest.getExtensions().get("prompt") != null) {
            String prompt = (String)authRequest.getExtensions().get("prompt");
            List prompts = Splitter.on((String)" ").splitToList((CharSequence)Strings.nullToEmpty((String)prompt));
            if (prompts.contains("none")) {
                this.logger.info("Client requested no prompt");
                Authentication auth = SecurityContextHolder.getContext().getAuthentication();
                if (auth != null) {
                    chain.doFilter(req, res);
                    return;
                }
                this.logger.info("User not logged in, no prompt requested, returning 403 from filter");
                response.sendError(403, "Access Denied");
                return;
            }
            if (!prompts.contains("login")) {
                chain.doFilter(req, res);
                return;
            }
            HttpSession session = request.getSession();
            if (session.getAttribute(PROMPTED) != null) {
                session.removeAttribute(PROMPTED);
                chain.doFilter(req, res);
                return;
            }
            session.setAttribute(PROMPT_REQUESTED, (Object)Boolean.TRUE);
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            if (auth != null) {
                SecurityContextHolder.getContext().setAuthentication(null);
                chain.doFilter(req, res);
                return;
            }
            chain.doFilter(req, res);
            return;
        }
        if (authRequest.getExtensions().get("max_age") == null) {
            chain.doFilter(req, res);
            return;
        }
        String maxAge = (String)authRequest.getExtensions().get("max_age");
        HttpSession session = request.getSession();
        Date authTime = (Date)session.getAttribute("AUTH_TIMESTAMP");
        Date now = new Date();
        if (authTime != null) {
            Integer max = Integer.parseInt(maxAge);
            long seconds = (now.getTime() - authTime.getTime()) / 1000L;
            if (seconds > (long)max.intValue()) {
                SecurityContextHolder.getContext().setAuthentication(null);
            }
        }
        chain.doFilter(req, res);
    }

    private Map<String, String> createRequestMap(Map<String, String[]> parameterMap) {
        HashMap<String, String> requestMap = new HashMap<String, String>();
        for (String key : parameterMap.keySet()) {
            String[] val = parameterMap.get(key);
            if (val == null || val.length <= 0) continue;
            requestMap.put(key, val[0]);
        }
        return requestMap;
    }
}

