/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.service.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.mitre.jwt.signer.service.JwtSigningAndValidationService;
import org.mitre.oauth2.model.AuthenticationHolderEntity;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.repository.AuthenticationHolderRepository;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.mitre.openid.connect.service.OIDCTokenService;
import org.mitre.openid.connect.util.IdTokenHashUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.stereotype.Service;

@Service
public class DefaultOIDCTokenService
implements OIDCTokenService {
    Logger logger = LoggerFactory.getLogger(DefaultOIDCTokenService.class);
    @Autowired
    private JwtSigningAndValidationService jwtService;
    @Autowired
    private AuthenticationHolderRepository authenticationHolderRepository;
    @Autowired
    private ConfigurationPropertiesBean configBean;

    public OAuth2AccessTokenEntity createIdToken(ClientDetailsEntity client, OAuth2Request request, Date issueTime, String sub, JWSAlgorithm signingAlg, OAuth2AccessTokenEntity accessToken) {
        Set responseTypes;
        OAuth2AccessTokenEntity idTokenEntity = new OAuth2AccessTokenEntity();
        JWTClaimsSet idClaims = new JWTClaimsSet();
        if (request.getExtensions().containsKey("AUTH_TIMESTAMP")) {
            Date authTime = (Date)request.getExtensions().get("AUTH_TIMESTAMP");
            idClaims.setClaim("auth_time", (Object)(authTime.getTime() / 1000L));
        }
        idClaims.setIssueTime(issueTime);
        if (client.getIdTokenValiditySeconds() != null) {
            Date expiration = new Date(System.currentTimeMillis() + (long)client.getIdTokenValiditySeconds().intValue() * 1000L);
            idClaims.setExpirationTime(expiration);
            idTokenEntity.setExpiration(expiration);
        }
        idClaims.setIssuer(this.configBean.getIssuer());
        idClaims.setSubject(sub);
        idClaims.setAudience((List)Lists.newArrayList((Object[])new String[]{client.getClientId()}));
        String nonce = (String)request.getExtensions().get("nonce");
        if (!Strings.isNullOrEmpty((String)nonce)) {
            idClaims.setCustomClaim("nonce", (Object)nonce);
        }
        if ((responseTypes = request.getResponseTypes()).contains("token")) {
            Base64URL at_hash = IdTokenHashUtils.getAccessTokenHash(signingAlg, accessToken);
            idClaims.setClaim("at_hash", (Object)at_hash);
        }
        SignedJWT idToken = new SignedJWT(new JWSHeader(signingAlg), (ReadOnlyJWTClaimsSet)idClaims);
        this.jwtService.signJwt(idToken);
        idTokenEntity.setJwt((JWT)idToken);
        idTokenEntity.setAuthenticationHolder(accessToken.getAuthenticationHolder());
        HashSet idScopes = Sets.newHashSet((Object[])new String[]{"id-token"});
        idTokenEntity.setScope((Set)idScopes);
        idTokenEntity.setClient(accessToken.getClient());
        return idTokenEntity;
    }

    public OAuth2AccessTokenEntity createRegistrationAccessToken(ClientDetailsEntity client) {
        HashMap authorizationParameters = Maps.newHashMap();
        OAuth2Request clientAuth = new OAuth2Request((Map)authorizationParameters, client.getClientId(), (Collection)Sets.newHashSet((Object[])new SimpleGrantedAuthority[]{new SimpleGrantedAuthority("ROLE_CLIENT")}), true, (Set)Sets.newHashSet((Object[])new String[]{"registration-token"}), null, null, null, null);
        OAuth2Authentication authentication = new OAuth2Authentication(clientAuth, null);
        OAuth2AccessTokenEntity token = new OAuth2AccessTokenEntity();
        token.setClient(client);
        token.setScope((Set)Sets.newHashSet((Object[])new String[]{"registration-token"}));
        AuthenticationHolderEntity authHolder = new AuthenticationHolderEntity();
        authHolder.setAuthentication(authentication);
        authHolder = this.authenticationHolderRepository.save(authHolder);
        token.setAuthenticationHolder(authHolder);
        JWTClaimsSet claims = new JWTClaimsSet();
        claims.setAudience((List)Lists.newArrayList((Object[])new String[]{client.getClientId()}));
        claims.setIssuer(this.configBean.getIssuer());
        claims.setIssueTime(new Date());
        claims.setExpirationTime(token.getExpiration());
        claims.setJWTID(UUID.randomUUID().toString());
        JWSAlgorithm signingAlg = this.jwtService.getDefaultSigningAlgorithm();
        SignedJWT signed = new SignedJWT(new JWSHeader(signingAlg), (ReadOnlyJWTClaimsSet)claims);
        this.jwtService.signJwt(signed);
        token.setJwt((JWT)signed);
        return token;
    }

    public ConfigurationPropertiesBean getConfigBean() {
        return this.configBean;
    }

    public void setConfigBean(ConfigurationPropertiesBean configBean) {
        this.configBean = configBean;
    }

    public JwtSigningAndValidationService getJwtService() {
        return this.jwtService;
    }

    public void setJwtService(JwtSigningAndValidationService jwtService) {
        this.jwtService = jwtService;
    }

    public AuthenticationHolderRepository getAuthenticationHolderRepository() {
        return this.authenticationHolderRepository;
    }

    public void setAuthenticationHolderRepository(AuthenticationHolderRepository authenticationHolderRepository) {
        this.authenticationHolderRepository = authenticationHolderRepository;
    }
}

