/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.web;

import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component(value="authenticationTimeStamper")
public class AuthenticationTimeStamper
extends SavedRequestAwareAuthenticationSuccessHandler {
    private static Logger logger = LoggerFactory.getLogger(AuthenticationTimeStamper.class);
    public static final String AUTH_TIMESTAMP = "AUTH_TIMESTAMP";

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        Date authTimestamp = new Date();
        HttpSession session = request.getSession();
        session.setAttribute(AUTH_TIMESTAMP, (Object)authTimestamp);
        if (session.getAttribute("PROMPT_FILTER_REQUESTED") != null) {
            session.setAttribute("PROMPT_FILTER_PROMPTED", (Object)Boolean.TRUE);
            session.removeAttribute("PROMPT_FILTER_REQUESTED");
        }
        logger.info("Successful Authentication at " + authTimestamp.toString());
        super.onAuthenticationSuccess(request, response, authentication);
    }
}

