/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.web;

import com.google.common.base.Strings;
import org.mitre.openid.connect.model.UserInfo;
import org.mitre.openid.connect.service.UserInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class UserInfoEndpoint {
    @Autowired
    private UserInfoService userInfoService;
    private static Logger logger = LoggerFactory.getLogger(UserInfoEndpoint.class);

    @PreAuthorize(value="hasRole('ROLE_USER') and #oauth2.hasScope('openid')")
    @RequestMapping(value={"/userinfo"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json"})
    public String getInfo(@RequestParam(value="claims", required=false) String claimsRequestJsonString, OAuth2Authentication auth, Model model) {
        if (auth == null) {
            logger.error("getInfo failed; no principal. Requester is not authorized.");
            model.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
            return "httpCodeView";
        }
        String username = auth.getName();
        UserInfo userInfo = this.userInfoService.getByUsernameAndClientId(username, auth.getOAuth2Request().getClientId());
        if (userInfo == null) {
            logger.error("getInfo failed; user not found: " + username);
            model.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
            return "httpCodeView";
        }
        model.addAttribute("scope", (Object)auth.getOAuth2Request().getScope());
        model.addAttribute("authorizedClaims", auth.getOAuth2Request().getExtensions().get("claims"));
        if (!Strings.isNullOrEmpty((String)claimsRequestJsonString)) {
            model.addAttribute("requestedClaims", (Object)claimsRequestJsonString);
        }
        model.addAttribute("userInfo", (Object)userInfo);
        return "userInfoView";
    }
}

