/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.service.impl;

import com.google.common.collect.Sets;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.mitre.oauth2.model.AuthenticationHolderEntity;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.mitre.oauth2.repository.AuthenticationHolderRepository;
import org.mitre.oauth2.repository.OAuth2TokenRepository;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.mitre.oauth2.service.SystemScopeService;
import org.mitre.openid.connect.model.ApprovedSite;
import org.mitre.openid.connect.service.ApprovedSiteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.stereotype.Service;

@Service(value="defaultOAuth2ProviderTokenService")
public class DefaultOAuth2ProviderTokenService
implements OAuth2TokenEntityService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultOAuth2ProviderTokenService.class);
    @Autowired
    private OAuth2TokenRepository tokenRepository;
    @Autowired
    private AuthenticationHolderRepository authenticationHolderRepository;
    @Autowired
    private ClientDetailsEntityService clientDetailsService;
    @Autowired
    private TokenEnhancer tokenEnhancer;
    @Autowired
    private SystemScopeService scopeService;
    @Autowired
    private ApprovedSiteService approvedSiteService;

    public Set<OAuth2AccessTokenEntity> getAllAccessTokensForUser(String id) {
        Set all = this.tokenRepository.getAllAccessTokens();
        LinkedHashSet results = Sets.newLinkedHashSet();
        for (OAuth2AccessTokenEntity token : all) {
            if (this.clearExpiredAccessToken(token) == null || !token.getAuthenticationHolder().getAuthentication().getName().equals(id)) continue;
            results.add(token);
        }
        return results;
    }

    public Set<OAuth2RefreshTokenEntity> getAllRefreshTokensForUser(String id) {
        Set all = this.tokenRepository.getAllRefreshTokens();
        LinkedHashSet results = Sets.newLinkedHashSet();
        for (OAuth2RefreshTokenEntity token : all) {
            if (this.clearExpiredRefreshToken(token) == null || !token.getAuthenticationHolder().getAuthentication().getName().equals(id)) continue;
            results.add(token);
        }
        return results;
    }

    public OAuth2AccessTokenEntity getAccessTokenById(Long id) {
        return this.clearExpiredAccessToken(this.tokenRepository.getAccessTokenById(id));
    }

    public OAuth2RefreshTokenEntity getRefreshTokenById(Long id) {
        return this.clearExpiredRefreshToken(this.tokenRepository.getRefreshTokenById(id));
    }

    private OAuth2AccessTokenEntity clearExpiredAccessToken(OAuth2AccessTokenEntity token) {
        if (token == null) {
            return null;
        }
        if (token.isExpired()) {
            logger.debug("Clearing expired access token: " + token.getValue());
            this.revokeAccessToken(token);
            return null;
        }
        return token;
    }

    private OAuth2RefreshTokenEntity clearExpiredRefreshToken(OAuth2RefreshTokenEntity token) {
        if (token == null) {
            return null;
        }
        if (token.isExpired()) {
            logger.debug("Clearing expired refresh token: " + token.getValue());
            this.revokeRefreshToken(token);
            return null;
        }
        return token;
    }

    public OAuth2AccessTokenEntity createAccessToken(OAuth2Authentication authentication) throws AuthenticationException, InvalidClientException {
        if (authentication != null && authentication.getOAuth2Request() != null) {
            OAuth2Request clientAuth = authentication.getOAuth2Request();
            ClientDetailsEntity client = this.clientDetailsService.loadClientByClientId(clientAuth.getClientId());
            if (client == null) {
                throw new InvalidClientException("Client not found: " + clientAuth.getClientId());
            }
            OAuth2AccessTokenEntity token = new OAuth2AccessTokenEntity();
            token.setClient(client);
            Set scopes = this.scopeService.fromStrings(clientAuth.getScope());
            scopes = this.scopeService.removeReservedScopes(scopes);
            token.setScope(this.scopeService.toStrings(scopes));
            if (client.getAccessTokenValiditySeconds() != null && client.getAccessTokenValiditySeconds() > 0) {
                Date expiration = new Date(System.currentTimeMillis() + (long)client.getAccessTokenValiditySeconds().intValue() * 1000L);
                token.setExpiration(expiration);
            }
            AuthenticationHolderEntity authHolder = new AuthenticationHolderEntity();
            authHolder.setAuthentication(authentication);
            authHolder = this.authenticationHolderRepository.save(authHolder);
            token.setAuthenticationHolder(authHolder);
            if (client.isAllowRefresh() && token.getScope().contains("offline_access")) {
                OAuth2RefreshTokenEntity savedRefreshToken = this.createRefreshToken(client, authHolder);
                token.setRefreshToken(savedRefreshToken);
            }
            OAuth2AccessTokenEntity enhancedToken = (OAuth2AccessTokenEntity)this.tokenEnhancer.enhance((OAuth2AccessToken)token, authentication);
            OAuth2AccessTokenEntity savedToken = this.tokenRepository.saveAccessToken(enhancedToken);
            OAuth2Request originalAuthRequest = authHolder.getAuthentication().getOAuth2Request();
            if (originalAuthRequest.getExtensions() != null && originalAuthRequest.getExtensions().containsKey("approved_site")) {
                Long apId = Long.parseLong((String)originalAuthRequest.getExtensions().get("approved_site"));
                ApprovedSite ap = this.approvedSiteService.getById(apId);
                Set apTokens = ap.getApprovedAccessTokens();
                apTokens.add(savedToken);
                ap.setApprovedAccessTokens(apTokens);
                this.approvedSiteService.save(ap);
            }
            if (savedToken.getRefreshToken() != null) {
                this.tokenRepository.saveRefreshToken(savedToken.getRefreshToken());
            }
            return savedToken;
        }
        throw new AuthenticationCredentialsNotFoundException("No authentication credentials found");
    }

    private OAuth2RefreshTokenEntity createRefreshToken(ClientDetailsEntity client, AuthenticationHolderEntity authHolder) {
        OAuth2RefreshTokenEntity refreshToken = new OAuth2RefreshTokenEntity();
        JWTClaimsSet.Builder refreshClaims = new JWTClaimsSet.Builder();
        if (client.getRefreshTokenValiditySeconds() != null) {
            Date expiration = new Date(System.currentTimeMillis() + (long)client.getRefreshTokenValiditySeconds().intValue() * 1000L);
            refreshToken.setExpiration(expiration);
            refreshClaims.expirationTime(expiration);
        }
        refreshClaims.jwtID(UUID.randomUUID().toString());
        PlainJWT refreshJwt = new PlainJWT(refreshClaims.build());
        refreshToken.setJwt((JWT)refreshJwt);
        refreshToken.setAuthenticationHolder(authHolder);
        refreshToken.setClient(client);
        OAuth2RefreshTokenEntity savedRefreshToken = this.tokenRepository.saveRefreshToken(refreshToken);
        return savedRefreshToken;
    }

    /*
     * Enabled aggressive block sorting
     */
    public OAuth2AccessTokenEntity refreshAccessToken(String refreshTokenValue, TokenRequest authRequest) throws AuthenticationException {
        OAuth2AccessTokenEntity token;
        AuthenticationHolderEntity authHolder;
        ClientDetailsEntity client;
        OAuth2RefreshTokenEntity refreshToken;
        block11: {
            refreshToken = this.clearExpiredRefreshToken(this.tokenRepository.getRefreshTokenByValue(refreshTokenValue));
            if (refreshToken == null) {
                throw new InvalidTokenException("Invalid refresh token: " + refreshTokenValue);
            }
            client = refreshToken.getClient();
            authHolder = refreshToken.getAuthenticationHolder();
            ClientDetailsEntity requestingClient = this.clientDetailsService.loadClientByClientId(authRequest.getClientId());
            if (!client.getClientId().equals(requestingClient.getClientId())) {
                this.tokenRepository.removeRefreshToken(refreshToken);
                throw new InvalidClientException("Client does not own the presented refresh token");
            }
            if (!client.isAllowRefresh()) {
                throw new InvalidClientException("Client does not allow refreshing access token!");
            }
            if (client.isClearAccessTokensOnRefresh()) {
                this.tokenRepository.clearAccessTokensForRefreshToken(refreshToken);
            }
            if (refreshToken.isExpired()) {
                this.tokenRepository.removeRefreshToken(refreshToken);
                throw new InvalidTokenException("Expired refresh token: " + refreshTokenValue);
            }
            token = new OAuth2AccessTokenEntity();
            HashSet refreshScopesRequested = new HashSet(refreshToken.getAuthenticationHolder().getAuthentication().getOAuth2Request().getScope());
            Set refreshScopes = this.scopeService.fromStrings(refreshScopesRequested);
            refreshScopes = this.scopeService.removeReservedScopes(refreshScopes);
            HashSet scopeRequested = authRequest.getScope() == null ? new HashSet() : new HashSet(authRequest.getScope());
            Set scope = this.scopeService.fromStrings(scopeRequested);
            if ((scope = this.scopeService.removeReservedScopes(scope)) != null && !scope.isEmpty()) {
                if (refreshScopes != null && refreshScopes.containsAll(scope)) {
                    token.setScope(this.scopeService.toStrings(scope));
                    break block11;
                } else {
                    String errorMsg = "Up-scoping is not allowed.";
                    logger.error(errorMsg);
                    throw new InvalidScopeException(errorMsg);
                }
            }
            token.setScope(this.scopeService.toStrings(refreshScopes));
        }
        token.setClient(client);
        if (client.getAccessTokenValiditySeconds() != null) {
            Date expiration = new Date(System.currentTimeMillis() + (long)client.getAccessTokenValiditySeconds().intValue() * 1000L);
            token.setExpiration(expiration);
        }
        if (client.isReuseRefreshToken()) {
            token.setRefreshToken(refreshToken);
        } else {
            OAuth2RefreshTokenEntity newRefresh = this.createRefreshToken(client, authHolder);
            token.setRefreshToken(newRefresh);
            this.tokenRepository.removeRefreshToken(refreshToken);
        }
        token.setAuthenticationHolder(authHolder);
        this.tokenEnhancer.enhance((OAuth2AccessToken)token, authHolder.getAuthentication());
        this.tokenRepository.saveAccessToken(token);
        return token;
    }

    public OAuth2Authentication loadAuthentication(String accessTokenValue) throws AuthenticationException {
        OAuth2AccessTokenEntity accessToken = this.clearExpiredAccessToken(this.tokenRepository.getAccessTokenByValue(accessTokenValue));
        if (accessToken == null) {
            throw new InvalidTokenException("Invalid access token: " + accessTokenValue);
        }
        return accessToken.getAuthenticationHolder().getAuthentication();
    }

    public OAuth2AccessTokenEntity readAccessToken(String accessTokenValue) throws AuthenticationException {
        OAuth2AccessTokenEntity accessToken = this.clearExpiredAccessToken(this.tokenRepository.getAccessTokenByValue(accessTokenValue));
        if (accessToken == null) {
            throw new InvalidTokenException("Access token for value " + accessTokenValue + " was not found");
        }
        return accessToken;
    }

    public OAuth2AccessTokenEntity getAccessToken(OAuth2Authentication authentication) {
        throw new UnsupportedOperationException("Unable to look up access token from authentication object.");
    }

    public OAuth2RefreshTokenEntity getRefreshToken(String refreshTokenValue) throws AuthenticationException {
        OAuth2RefreshTokenEntity refreshToken = this.tokenRepository.getRefreshTokenByValue(refreshTokenValue);
        if (refreshToken == null) {
            throw new InvalidTokenException("Refresh token for value " + refreshTokenValue + " was not found");
        }
        return refreshToken;
    }

    public void revokeRefreshToken(OAuth2RefreshTokenEntity refreshToken) {
        this.tokenRepository.clearAccessTokensForRefreshToken(refreshToken);
        this.tokenRepository.removeRefreshToken(refreshToken);
    }

    public void revokeAccessToken(OAuth2AccessTokenEntity accessToken) {
        this.tokenRepository.removeAccessToken(accessToken);
    }

    public List<OAuth2AccessTokenEntity> getAccessTokensForClient(ClientDetailsEntity client) {
        return this.tokenRepository.getAccessTokensForClient(client);
    }

    public List<OAuth2RefreshTokenEntity> getRefreshTokensForClient(ClientDetailsEntity client) {
        return this.tokenRepository.getRefreshTokensForClient(client);
    }

    public void clearExpiredTokens() {
        logger.debug("Cleaning out all expired tokens");
        this.tokenRepository.clearDuplicateAccessTokens();
        this.tokenRepository.clearDuplicateRefreshTokens();
        Collection<OAuth2AccessTokenEntity> accessTokens = this.getExpiredAccessTokens();
        if (accessTokens.size() > 0) {
            logger.info("Found " + accessTokens.size() + " expired access tokens");
        }
        for (OAuth2AccessTokenEntity oAuth2AccessTokenEntity : accessTokens) {
            try {
                this.revokeAccessToken(oAuth2AccessTokenEntity);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        Collection<OAuth2RefreshTokenEntity> refreshTokens = this.getExpiredRefreshTokens();
        if (refreshTokens.size() > 0) {
            logger.info("Found " + refreshTokens.size() + " expired refresh tokens");
        }
        for (OAuth2RefreshTokenEntity oAuth2RefreshTokenEntity : refreshTokens) {
            this.revokeRefreshToken(oAuth2RefreshTokenEntity);
        }
        Collection<AuthenticationHolderEntity> collection = this.getOrphanedAuthenticationHolders();
        if (collection.size() > 0) {
            logger.info("Found " + collection.size() + " orphaned authentication holders");
        }
        for (AuthenticationHolderEntity authHolder : collection) {
            this.authenticationHolderRepository.remove(authHolder);
        }
    }

    private Collection<OAuth2AccessTokenEntity> getExpiredAccessTokens() {
        return Sets.newHashSet((Iterable)this.tokenRepository.getAllExpiredAccessTokens());
    }

    private Collection<OAuth2RefreshTokenEntity> getExpiredRefreshTokens() {
        return Sets.newHashSet((Iterable)this.tokenRepository.getAllExpiredRefreshTokens());
    }

    private Collection<AuthenticationHolderEntity> getOrphanedAuthenticationHolders() {
        return Sets.newHashSet((Iterable)this.authenticationHolderRepository.getOrphanedAuthenticationHolders());
    }

    public OAuth2AccessTokenEntity saveAccessToken(OAuth2AccessTokenEntity accessToken) {
        return this.tokenRepository.saveAccessToken(accessToken);
    }

    public OAuth2RefreshTokenEntity saveRefreshToken(OAuth2RefreshTokenEntity refreshToken) {
        return this.tokenRepository.saveRefreshToken(refreshToken);
    }

    public TokenEnhancer getTokenEnhancer() {
        return this.tokenEnhancer;
    }

    public void setTokenEnhancer(TokenEnhancer tokenEnhancer) {
        this.tokenEnhancer = tokenEnhancer;
    }

    public OAuth2AccessTokenEntity getAccessTokenForIdToken(OAuth2AccessTokenEntity idToken) {
        return this.tokenRepository.getAccessTokenForIdToken(idToken);
    }

    public OAuth2AccessTokenEntity getRegistrationAccessTokenForClient(ClientDetailsEntity client) {
        List<OAuth2AccessTokenEntity> allTokens = this.getAccessTokensForClient(client);
        for (OAuth2AccessTokenEntity token : allTokens) {
            if (!token.getScope().contains("registration-token") && !token.getScope().contains("resource-token") || token.getScope().size() != 1) continue;
            return token;
        }
        return null;
    }
}

