/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.web;

import java.security.Principal;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class RevocationEndpoint {
    @Autowired
    OAuth2TokenEntityService tokenServices;
    private static final Logger logger = LoggerFactory.getLogger(RevocationEndpoint.class);
    public static final String URL = "revoke";

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_CLIENT')")
    @RequestMapping(value={"/revoke"})
    public String revoke(@RequestParam(value="token") String tokenValue, @RequestParam(value="token_type_hint", required=false) String tokenType, Principal principal, Model model) {
        OAuth2Request authRequest = null;
        if (principal instanceof OAuth2Authentication) {
            authRequest = ((OAuth2Authentication)principal).getOAuth2Request();
        }
        try {
            OAuth2AccessTokenEntity accessToken = this.tokenServices.readAccessToken(tokenValue);
            if (authRequest != null && !accessToken.getClient().getClientId().equals(authRequest.getClientId())) {
                model.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
                return "httpCodeView";
            }
            this.tokenServices.revokeAccessToken(accessToken);
            model.addAttribute("code", (Object)HttpStatus.OK);
            return "httpCodeView";
        }
        catch (InvalidTokenException e) {
            try {
                OAuth2RefreshTokenEntity refreshToken = this.tokenServices.getRefreshToken(tokenValue);
                if (authRequest != null && !refreshToken.getClient().getClientId().equals(authRequest.getClientId())) {
                    model.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
                    return "httpCodeView";
                }
                this.tokenServices.revokeRefreshToken(refreshToken);
                model.addAttribute("code", (Object)HttpStatus.OK);
                return "httpCodeView";
            }
            catch (InvalidTokenException e1) {
                model.addAttribute("code", (Object)HttpStatus.OK);
                return "httpCodeView";
            }
        }
    }
}

