/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.assertion;

import com.google.common.base.Strings;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.io.IOException;
import java.text.ParseException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mitre.openid.connect.assertion.JWTBearerAssertionAuthenticationToken;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.exceptions.BadClientCredentialsException;
import org.springframework.security.oauth2.provider.error.OAuth2AuthenticationEntryPoint;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class JWTBearerClientAssertionTokenEndpointFilter
extends AbstractAuthenticationProcessingFilter {
    private AuthenticationEntryPoint authenticationEntryPoint = new OAuth2AuthenticationEntryPoint();

    public JWTBearerClientAssertionTokenEndpointFilter(RequestMatcher additionalMatcher) {
        super((RequestMatcher)new ClientAssertionRequestMatcher(additionalMatcher));
        ((OAuth2AuthenticationEntryPoint)this.authenticationEntryPoint).setTypeName("Form");
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.setAuthenticationFailureHandler(new AuthenticationFailureHandler(){

            public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
                if (exception instanceof BadCredentialsException) {
                    exception = new BadCredentialsException(exception.getMessage(), (Throwable)new BadClientCredentialsException());
                }
                JWTBearerClientAssertionTokenEndpointFilter.this.authenticationEntryPoint.commence(request, response, exception);
            }
        });
        this.setAuthenticationSuccessHandler(new AuthenticationSuccessHandler(){

            public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
            }
        });
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        String assertionType = request.getParameter("client_assertion_type");
        String assertion = request.getParameter("client_assertion");
        try {
            JWT jwt = JWTParser.parse((String)assertion);
            String clientId = jwt.getJWTClaimsSet().getSubject();
            JWTBearerAssertionAuthenticationToken authRequest = new JWTBearerAssertionAuthenticationToken(clientId, jwt);
            return this.getAuthenticationManager().authenticate((Authentication)authRequest);
        }
        catch (ParseException e) {
            throw new BadCredentialsException("Invalid JWT credential: " + assertion);
        }
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        super.successfulAuthentication(request, response, chain, authResult);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private static class ClientAssertionRequestMatcher
    implements RequestMatcher {
        private RequestMatcher additionalMatcher;

        public ClientAssertionRequestMatcher(RequestMatcher additionalMatcher) {
            this.additionalMatcher = additionalMatcher;
        }

        public boolean matches(HttpServletRequest request) {
            String assertionType = request.getParameter("client_assertion_type");
            String assertion = request.getParameter("client_assertion");
            if (Strings.isNullOrEmpty((String)assertionType) || Strings.isNullOrEmpty((String)assertion)) {
                return false;
            }
            if (!assertionType.equals("urn:ietf:params:oauth:client-assertion-type:jwt-bearer")) {
                return false;
            }
            return this.additionalMatcher.matches(request);
        }
    }
}

