/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.filter;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.http.client.utils.URIBuilder;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.openid.connect.service.LoginHintExtracter;
import org.mitre.openid.connect.service.impl.RemoveLoginHintsWithHTTP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.endpoint.RedirectResolver;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Component(value="authRequestFilter")
public class AuthorizationRequestFilter
extends GenericFilterBean {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationRequestFilter.class);
    public static final String PROMPTED = "PROMPT_FILTER_PROMPTED";
    public static final String PROMPT_REQUESTED = "PROMPT_FILTER_REQUESTED";
    @Autowired
    private OAuth2RequestFactory authRequestFactory;
    @Autowired
    private ClientDetailsEntityService clientService;
    @Autowired
    private RedirectResolver redirectResolver;
    @Autowired(required=false)
    private LoginHintExtracter loginHintExtracter = new RemoveLoginHintsWithHTTP();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        HttpSession session = request.getSession();
        if (!request.getServletPath().startsWith("/authorize")) {
            chain.doFilter(req, res);
            return;
        }
        try {
            String loginHint;
            AuthorizationRequest authRequest = null;
            ClientDetailsEntity client = null;
            authRequest = this.authRequestFactory.createAuthorizationRequest(this.createRequestMap(request.getParameterMap()));
            if (!Strings.isNullOrEmpty((String)authRequest.getClientId())) {
                client = this.clientService.loadClientByClientId(authRequest.getClientId());
            }
            if (!Strings.isNullOrEmpty((String)(loginHint = this.loginHintExtracter.extractHint((String)authRequest.getExtensions().get("login_hint"))))) {
                session.setAttribute("login_hint", (Object)loginHint);
            } else {
                session.removeAttribute("login_hint");
            }
            if (authRequest.getExtensions().get("prompt") != null) {
                String prompt = (String)authRequest.getExtensions().get("prompt");
                List prompts = Splitter.on((String)" ").splitToList((CharSequence)Strings.nullToEmpty((String)prompt));
                if (prompts.contains("none")) {
                    Authentication auth = SecurityContextHolder.getContext().getAuthentication();
                    if (auth != null) {
                        chain.doFilter(req, res);
                        return;
                    }
                    logger.info("Client requested no prompt");
                    if (client != null && authRequest.getRedirectUri() != null) {
                        String url = this.redirectResolver.resolveRedirect(authRequest.getRedirectUri(), (ClientDetails)client);
                        try {
                            URIBuilder uriBuilder = new URIBuilder(url);
                            uriBuilder.addParameter("error", "login_required");
                            if (!Strings.isNullOrEmpty((String)authRequest.getState())) {
                                uriBuilder.addParameter("state", authRequest.getState());
                            }
                            response.sendRedirect(uriBuilder.toString());
                            return;
                        }
                        catch (URISyntaxException e) {
                            logger.error("Can't build redirect URI for prompt=none, sending error instead", (Throwable)e);
                            response.sendError(403, "Access Denied");
                            return;
                        }
                    }
                    response.sendError(403, "Access Denied");
                    return;
                }
                if (!prompts.contains("login")) {
                    chain.doFilter(req, res);
                    return;
                }
                if (session.getAttribute(PROMPTED) != null) {
                    session.removeAttribute(PROMPTED);
                    chain.doFilter(req, res);
                    return;
                }
                session.setAttribute(PROMPT_REQUESTED, (Object)Boolean.TRUE);
                Authentication auth = SecurityContextHolder.getContext().getAuthentication();
                if (auth != null) {
                    SecurityContextHolder.getContext().setAuthentication(null);
                    chain.doFilter(req, res);
                    return;
                }
                chain.doFilter(req, res);
                return;
            }
            if (authRequest.getExtensions().get("max_age") != null || client != null && client.getDefaultMaxAge() != null) {
                Integer max = client != null ? client.getDefaultMaxAge() : null;
                String maxAge = (String)authRequest.getExtensions().get("max_age");
                if (maxAge != null) {
                    max = Integer.parseInt(maxAge);
                }
                if (max != null) {
                    long seconds;
                    Date authTime = (Date)session.getAttribute("AUTH_TIMESTAMP");
                    Date now = new Date();
                    if (authTime != null && (seconds = (now.getTime() - authTime.getTime()) / 1000L) > (long)max.intValue()) {
                        SecurityContextHolder.getContext().setAuthentication(null);
                    }
                }
                chain.doFilter(req, res);
                return;
            }
            chain.doFilter(req, res);
            return;
        }
        catch (InvalidClientException e) {
            chain.doFilter(req, res);
        }
    }

    private Map<String, String> createRequestMap(Map<String, String[]> parameterMap) {
        HashMap<String, String> requestMap = new HashMap<String, String>();
        for (String key : parameterMap.keySet()) {
            String[] val = parameterMap.get(key);
            if (val == null || val.length <= 0) continue;
            requestMap.put(key, val[0]);
        }
        return requestMap;
    }
}

