/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.view;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWKSet;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.view.AbstractView;

public abstract class AbstractClientEntityView
extends AbstractView {
    private static final Logger logger = LoggerFactory.getLogger(AbstractClientEntityView.class);
    private JsonParser parser = new JsonParser();
    private Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{this.getExclusionStrategy()}).registerTypeAdapter(JWSAlgorithm.class, (Object)new JsonSerializer<JWSAlgorithm>(){

        public JsonElement serialize(JWSAlgorithm src, Type typeOfSrc, JsonSerializationContext context) {
            if (src != null) {
                return new JsonPrimitive(src.getName());
            }
            return null;
        }
    }).registerTypeAdapter(JWEAlgorithm.class, (Object)new JsonSerializer<JWEAlgorithm>(){

        public JsonElement serialize(JWEAlgorithm src, Type typeOfSrc, JsonSerializationContext context) {
            if (src != null) {
                return new JsonPrimitive(src.getName());
            }
            return null;
        }
    }).registerTypeAdapter(EncryptionMethod.class, (Object)new JsonSerializer<EncryptionMethod>(){

        public JsonElement serialize(EncryptionMethod src, Type typeOfSrc, JsonSerializationContext context) {
            if (src != null) {
                return new JsonPrimitive(src.getName());
            }
            return null;
        }
    }).registerTypeAdapter(JWKSet.class, (Object)new JsonSerializer<JWKSet>(){

        public JsonElement serialize(JWKSet src, Type typeOfSrc, JsonSerializationContext context) {
            if (src != null) {
                return AbstractClientEntityView.this.parser.parse(src.toString());
            }
            return null;
        }
    }).serializeNulls().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();

    protected abstract ExclusionStrategy getExclusionStrategy();

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/json");
        HttpStatus code = (HttpStatus)model.get("code");
        if (code == null) {
            code = HttpStatus.OK;
        }
        response.setStatus(code.value());
        try {
            PrintWriter out = response.getWriter();
            Object obj = model.get("entity");
            this.gson.toJson(obj, (Appendable)out);
        }
        catch (IOException e) {
            logger.error("IOException in JsonEntityView.java: ", (Throwable)e);
        }
    }
}

