/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.dashboard.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.mockserver.log.model.LogEntry;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.ObjectWithJsonToString;
import org.slf4j.event.Level;

public class DashboardLogEntryDTO
extends ObjectWithJsonToString {
    private static final String[] EXCLUDED_FIELDS = new String[]{"id", "timestamp", "message", "throwable"};
    private String id;
    private Level logLevel;
    private long epochTime;
    private String timestamp;
    private LogEntry.LogMessageType type;
    private HttpRequest[] httpRequests;
    private HttpResponse httpResponse;
    private HttpError httpError;
    private Expectation expectation;
    private Throwable throwable;
    private String messageFormat;
    private Object[] arguments;
    private String message;

    public DashboardLogEntryDTO(LogEntry logEntry) {
        this.setId(logEntry.id());
        this.setLogLevel(logEntry.getLogLevel());
        this.setTimestamp(logEntry.getTimestamp());
        this.setEpochTime(logEntry.getEpochTime());
        this.setType(logEntry.getType());
        this.setHttpRequests(logEntry.getHttpUpdatedRequests());
        this.setHttpResponse(logEntry.getHttpUpdatedResponse());
        this.setHttpError(logEntry.getHttpError());
        this.setExpectation(logEntry.getExpectation());
        this.setMessageFormat(logEntry.getMessageFormat());
        this.setArguments(logEntry.getArguments());
        this.setMessage(logEntry.getMessage());
        this.setThrowable(logEntry.getThrowable());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public DashboardLogEntryDTO setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public long getEpochTime() {
        return this.epochTime;
    }

    public DashboardLogEntryDTO setEpochTime(long epochTime) {
        this.epochTime = epochTime;
        return this;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public LogEntry.LogMessageType getType() {
        return this.type;
    }

    public DashboardLogEntryDTO setType(LogEntry.LogMessageType type) {
        this.type = type;
        return this;
    }

    @JsonIgnore
    public HttpRequest[] getHttpRequests() {
        return this.httpRequests;
    }

    public DashboardLogEntryDTO setHttpRequests(HttpRequest[] httpRequests) {
        this.httpRequests = httpRequests;
        return this;
    }

    public DashboardLogEntryDTO setHttpRequest(HttpRequest httpRequest) {
        this.httpRequests = httpRequest != null ? new HttpRequest[]{httpRequest} : new HttpRequest[]{HttpRequest.request()};
        return this;
    }

    public HttpRequest getHttpRequest() {
        if (this.httpRequests != null && this.httpRequests.length > 0) {
            return this.httpRequests[0];
        }
        return null;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public DashboardLogEntryDTO setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
        return this;
    }

    public HttpError getHttpError() {
        return this.httpError;
    }

    public DashboardLogEntryDTO setHttpError(HttpError httpError) {
        this.httpError = httpError;
        return this;
    }

    public Expectation getExpectation() {
        return this.expectation;
    }

    public DashboardLogEntryDTO setExpectation(Expectation expectation) {
        this.expectation = expectation;
        return this;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public DashboardLogEntryDTO setThrowable(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    public String getMessageFormat() {
        return this.messageFormat;
    }

    public DashboardLogEntryDTO setMessageFormat(String messageFormat) {
        this.messageFormat = messageFormat;
        return this;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public DashboardLogEntryDTO setArguments(Object ... arguments) {
        this.arguments = arguments;
        return this;
    }

    @JsonIgnore
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

