/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.command;

import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.fake.command.AbstractFakeCommandHandler;

public class RntoCommandHandler
extends AbstractFakeCommandHandler {
    @Override
    protected void handle(Command command, Session session) {
        this.verifyLoggedIn(session);
        String toPath = this.getRealPath(session, command.getRequiredParameter(0));
        String fromPath = (String)this.getRequiredSessionAttribute(session, "renameFrom");
        this.replyCodeForFileSystemException = 553;
        this.verifyFileSystemCondition(!this.getFileSystem().isDirectory(toPath), toPath, "filesystem.isDirectory");
        String parentPath = this.getFileSystem().getParent(toPath);
        this.verifyFileSystemCondition(this.notNullOrEmpty(parentPath), parentPath, "filesystem.doesNotExist");
        this.verifyFileSystemCondition(this.getFileSystem().exists(parentPath), parentPath, "filesystem.doesNotExist");
        this.verifyWritePermission(session, parentPath);
        this.getFileSystem().rename(fromPath, toPath);
        session.removeAttribute("renameFrom");
        this.sendReply(session, 250, "rnto", this.list(fromPath, toPath));
    }
}

