/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.filesystem;

import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import org.mockftpserver.core.util.StringUtil;
import org.mockftpserver.fake.filesystem.DirectoryListingFormatter;
import org.mockftpserver.fake.filesystem.FileSystemEntry;
import org.mockftpserver.fake.filesystem.Permissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixDirectoryListingFormatter
implements DirectoryListingFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(UnixDirectoryListingFormatter.class);
    protected static final String DATE_FORMAT_YEAR = "MMM dd  yyyy";
    protected static final String DATE_FORMAT_HOURS_MINUTES = "MMM dd HH:mm";
    private static final int SIZE_WIDTH = 15;
    private static final int OWNER_WIDTH = 8;
    private static final int GROUP_WIDTH = 8;
    private static final String NONE = "none";
    private Locale locale = Locale.ENGLISH;

    @Override
    public String format(FileSystemEntry fileSystemEntry) {
        String dateStr = this.formatLastModifiedDate(fileSystemEntry);
        String dirOrFile = fileSystemEntry.isDirectory() ? "d" : "-";
        String permissionsStr = this.formatPermissions(fileSystemEntry);
        String linkCountStr = "1";
        String ownerStr = StringUtil.padRight(this.stringOrNone(fileSystemEntry.getOwner()), 8);
        String groupStr = StringUtil.padRight(this.stringOrNone(fileSystemEntry.getGroup()), 8);
        String sizeStr = StringUtil.padLeft(Long.toString(fileSystemEntry.getSize()), 15);
        String listing = "" + dirOrFile + permissionsStr + "  " + linkCountStr + " " + ownerStr + " " + groupStr + " " + sizeStr + " " + dateStr + " " + fileSystemEntry.getName();
        LOG.info("listing=[" + listing + "]");
        return listing;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private String formatLastModifiedDate(FileSystemEntry fileSystemEntry) {
        Date showYearThresholdDate = Date.from(Instant.now().minus(Duration.ofDays(180L)));
        String formatString = fileSystemEntry.getLastModified().before(showYearThresholdDate) ? DATE_FORMAT_YEAR : DATE_FORMAT_HOURS_MINUTES;
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatString, this.locale);
        return dateFormat.format(fileSystemEntry.getLastModified());
    }

    private String formatPermissions(FileSystemEntry fileSystemEntry) {
        Permissions permissions = fileSystemEntry.getPermissions() != null ? fileSystemEntry.getPermissions() : Permissions.DEFAULT;
        return StringUtil.padRight(permissions.asRwxString(), 9);
    }

    private String stringOrNone(String string) {
        return string == null ? NONE : string;
    }
}

