/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.container;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.milyn.io.StreamUtils;
import org.milyn.resource.ContainerResourceLocator;

public class MockContainerResourceLocator
implements ContainerResourceLocator {
    public static final File TEST_STANDALONE_CTX_BASE = new File("src/test/standalone-ctx");
    private Hashtable streams = new Hashtable();

    public void setResource(String nameOrUri, InputStream stream) {
        try {
            byte[] streamData = StreamUtils.readStream(stream);
            this.streams.put(nameOrUri, streamData);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public InputStream getResource(String configName, String defaultUri) throws IllegalArgumentException, IOException {
        return this.getResource(defaultUri);
    }

    public InputStream getResource(String uri) throws IllegalArgumentException, IOException {
        File resFile;
        String relUri = uri;
        if (uri.charAt(0) == '\\' || uri.charAt(0) == '/') {
            relUri = uri.substring(1);
        }
        if ((resFile = new File(TEST_STANDALONE_CTX_BASE, relUri)).exists() && !resFile.isDirectory()) {
            return new FileInputStream(resFile);
        }
        byte[] resBytes = (byte[])this.streams.get(uri);
        if (resBytes == null) {
            throw new IllegalStateException("Resource [" + uri + "] not set in MockContainerResourceLocator OR loadable from the test standalone context.  Use MockContainerResourceLocator.setResource()");
        }
        return new ByteArrayInputStream(resBytes);
    }
}

