/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import org.milyn.SmooksException;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ExecutionLifecycleCleanable;
import org.milyn.delivery.VisitLifecycleCleanable;
import org.milyn.delivery.dom.DOMVisitBefore;
import org.milyn.delivery.ordering.Producer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.util.CollectionsUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataSource
implements SAXVisitBefore,
DOMVisitBefore,
Producer,
VisitLifecycleCleanable,
ExecutionLifecycleCleanable {
    private static final String DS_CONTEXT_KEY_PREFIX = AbstractDataSource.class.getName() + "#datasource:";
    private static final String CONNECTION_CONTEXT_KEY_PREFIX = AbstractDataSource.class.getName() + "#connection:";

    @Override
    public final void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.bind(executionContext);
    }

    @Override
    public final void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.bind(executionContext);
    }

    @Override
    public final void executeVisitLifecycleCleanup(ExecutionContext executionContext) {
        this.unbind(executionContext);
    }

    @Override
    public final void executeExecutionLifecycleCleanup(ExecutionContext executionContext) {
        this.unbind(executionContext);
    }

    private void bind(ExecutionContext executionContext) {
        executionContext.setAttribute(DS_CONTEXT_KEY_PREFIX + this.getName(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbind(ExecutionContext executionContext) {
        block11: {
            try {
                Connection connection = (Connection)executionContext.getAttribute(CONNECTION_CONTEXT_KEY_PREFIX + this.getName());
                if (connection == null) break block11;
                try {
                    if (!this.isAutoCommit()) {
                        if (executionContext.getTerminationError() == null) {
                            connection.commit();
                        } else {
                            connection.rollback();
                        }
                    }
                }
                finally {
                    executionContext.removeAttribute(CONNECTION_CONTEXT_KEY_PREFIX + this.getName());
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new SmooksException("Unable to unbind DataSource '" + this.getName() + "'.");
            }
            finally {
                executionContext.removeAttribute(DS_CONTEXT_KEY_PREFIX + this.getName());
            }
        }
    }

    public static Connection getConnection(String dataSourceName, ExecutionContext executionContext) throws SmooksException {
        Connection connection = (Connection)executionContext.getAttribute(CONNECTION_CONTEXT_KEY_PREFIX + dataSourceName);
        if (connection == null) {
            AbstractDataSource datasource = (AbstractDataSource)executionContext.getAttribute(DS_CONTEXT_KEY_PREFIX + dataSourceName);
            if (datasource == null) {
                throw new SmooksException("DataSource '" + dataSourceName + "' not bound to context.  Configure an '" + AbstractDataSource.class.getName() + "' implementation and target it at '#document'.");
            }
            try {
                connection = datasource.getConnection();
                connection.setAutoCommit(datasource.isAutoCommit());
            }
            catch (SQLException e) {
                throw new SmooksException("Unable to open connection to dataSource '" + dataSourceName + "'.", e);
            }
            executionContext.setAttribute(CONNECTION_CONTEXT_KEY_PREFIX + dataSourceName, connection);
        }
        return connection;
    }

    public Set<String> getProducts() {
        return CollectionsUtil.toSet(this.getName());
    }

    public abstract String getName();

    public abstract Connection getConnection() throws SQLException;

    public abstract boolean isAutoCommit();
}

