/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.milyn.assertion.AssertArgument;
import org.milyn.edisax.BufferedSegmentReader;
import org.milyn.edisax.EDIConfigurationException;
import org.milyn.edisax.EDIParseException;
import org.milyn.edisax.EDIUtils;
import org.milyn.edisax.model.EdifactModel;
import org.milyn.edisax.model.internal.Component;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.model.internal.SegmentGroup;
import org.milyn.edisax.model.internal.SubComponent;
import org.milyn.edisax.model.internal.ValueNode;
import org.milyn.io.StreamUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDIParser
implements XMLReader {
    protected static final String VALIDATE = "http://xml.org/sax/features/validation";
    private Map<String, Boolean> features;
    private ContentHandler contentHandler;
    private int depth = 0;
    private static Attributes EMPTY_ATTRIBS = new AttributesImpl();
    private static Pattern EMPTY_LINE = Pattern.compile("[\n\r ]*");
    private EdifactModel edifactModel;
    private BufferedSegmentReader segmentReader;
    private static final char[] indentChars = new String("\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").toCharArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EdifactModel parseMappingModel(InputStream mappingConfigStream) throws IOException, SAXException, EDIConfigurationException {
        AssertArgument.isNotNull(mappingConfigStream, "mappingConfigStream");
        try {
            EdifactModel edifactModel = EDIParser.parseMappingModel(new InputStreamReader(mappingConfigStream));
            return edifactModel;
        }
        finally {
            mappingConfigStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EdifactModel parseMappingModel(Reader mappingConfigStream) throws IOException, SAXException, EDIConfigurationException {
        String mappingConfig;
        AssertArgument.isNotNull(mappingConfigStream, "mappingConfigStream");
        try {
            mappingConfig = StreamUtils.readStream(mappingConfigStream);
        }
        finally {
            mappingConfigStream.close();
        }
        EdifactModel edifactModel = new EdifactModel();
        edifactModel.parseSequence(new ByteArrayInputStream(mappingConfig.getBytes()));
        return edifactModel;
    }

    public void setMappingModel(EdifactModel mappingModel) {
        AssertArgument.isNotNull(mappingModel, "mappingModel");
        this.edifactModel = mappingModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputSource ediInputSource) throws IOException, SAXException {
        if (this.contentHandler == null) {
            throw new IllegalStateException("'contentHandler' not set.  Cannot parse EDI stream.");
        }
        if (this.edifactModel == null || this.edifactModel.getEdimap() == null) {
            throw new IllegalStateException("'mappingModel' not set.  Cannot parse EDI stream.");
        }
        try {
            this.segmentReader = new BufferedSegmentReader(ediInputSource, this.edifactModel.getDelimiters());
            this.contentHandler.startDocument();
            this.startElement(this.edifactModel.getEdimap().getSegments().getXmltag(), false);
            if (this.segmentReader.moveToNextSegment()) {
                this.mapSegments(this.edifactModel.getEdimap().getSegments().getSegments());
                while (this.segmentReader.hasCurrentSegment()) {
                    if (!EMPTY_LINE.matcher(this.segmentReader.getCurrentSegment().toString()).matches()) {
                        throw new EDIParseException(this.edifactModel.getEdimap(), "Reached end of mapping model but there are more EDI segments in the incoming message.  Read " + this.segmentReader.getCurrentSegmentNumber() + " segment(s). Current EDI segment is [" + this.segmentReader.getCurrentSegment() + "]");
                    }
                    this.segmentReader.moveToNextSegment();
                }
            }
            this.endElement(this.edifactModel.getEdimap().getSegments().getXmltag(), true);
            this.contentHandler.endDocument();
        }
        finally {
            this.contentHandler = null;
        }
    }

    private void mapSegments(List<SegmentGroup> expectedSegments) throws IOException, SAXException {
        this.mapSegments(expectedSegments, null);
    }

    private void mapSegments(List<SegmentGroup> expectedSegments, String[] preLoadedSegmentFields) throws IOException, SAXException {
        int segmentMappingIndex = 0;
        int segmentProcessingCount = 0;
        String[] currentSegmentFields = preLoadedSegmentFields;
        if (expectedSegments.size() == 0) {
            return;
        }
        while (segmentMappingIndex < expectedSegments.size() && this.segmentReader.hasCurrentSegment()) {
            Matcher matcher;
            SegmentGroup expectedSegmentGroup = expectedSegments.get(segmentMappingIndex);
            int minOccurs = expectedSegmentGroup.getMinOccurs();
            int maxOccurs = expectedSegmentGroup.getMaxOccurs();
            if (maxOccurs < 0) {
                maxOccurs = Integer.MAX_VALUE;
            }
            if (minOccurs > maxOccurs) {
                maxOccurs = minOccurs;
            }
            if (currentSegmentFields == null) {
                currentSegmentFields = this.segmentReader.getCurrentSegmentFields();
            }
            if (!currentSegmentFields[0].equals(expectedSegmentGroup.getSegcode()) && !(matcher = expectedSegmentGroup.getSegcodePattern().matcher(this.segmentReader.getCurrentSegment())).matches()) {
                if (segmentProcessingCount < minOccurs) {
                    throw new EDIParseException(this.edifactModel.getEdimap(), "Must be a minimum of " + minOccurs + " instances of segment [" + expectedSegmentGroup.getSegcode() + "].  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".");
                }
                ++segmentMappingIndex;
                segmentProcessingCount = 0;
                continue;
            }
            if (segmentProcessingCount >= maxOccurs) {
                throw new EDIParseException(this.edifactModel.getEdimap(), "Maximum of " + maxOccurs + " instances of segment [" + expectedSegmentGroup.getSegcode() + "] exceeded.  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".");
            }
            if (expectedSegmentGroup instanceof Segment) {
                this.mapSegment(currentSegmentFields, (Segment)expectedSegmentGroup);
            } else {
                String xmlTag = expectedSegmentGroup.getXmltag();
                if (xmlTag != null) {
                    this.startElement(xmlTag, true);
                }
                this.mapSegments(expectedSegmentGroup.getSegments(), currentSegmentFields);
                if (xmlTag != null) {
                    this.endElement(xmlTag, true);
                }
            }
            currentSegmentFields = null;
            if (++segmentProcessingCount >= minOccurs || this.segmentReader.hasCurrentSegment()) continue;
            throw new EDIParseException(this.edifactModel.getEdimap(), "Reached end of EDI message stream but there must be a minimum of " + minOccurs + " instances of segment [" + expectedSegmentGroup.getSegcode() + "].  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".");
        }
    }

    private void mapSegment(String[] currentSegmentFields, Segment expectedSegment) throws IOException, SAXException {
        this.startElement(expectedSegment.getXmltag(), true);
        this.mapFields(currentSegmentFields, expectedSegment);
        if (this.segmentReader.moveToNextSegment()) {
            this.mapSegments(expectedSegment.getSegments());
        }
        this.endElement(expectedSegment.getXmltag(), true);
    }

    private void mapFields(String[] currentSegmentFields, Segment segment) throws SAXException {
        String segmentCode = segment.getSegcode();
        List<Field> expectedFields = segment.getFields();
        this.assertFieldsOK(currentSegmentFields, segment);
        int numFields = currentSegmentFields.length - 1;
        for (int i = 0; i < numFields; ++i) {
            String fieldMessageVal = currentSegmentFields[i + 1];
            Field expectedField = expectedFields.get(i);
            this.mapField(fieldMessageVal, expectedField, i, segmentCode);
        }
    }

    private void mapField(String fieldMessageVal, Field expectedField, int fieldIndex, String segmentCode) throws SAXException {
        List<Component> expectedComponents = expectedField.getComponent();
        this.startElement(expectedField.getXmltag(), true);
        if (expectedComponents.size() != 0) {
            String[] currentFieldComponents = EDIUtils.split(fieldMessageVal, this.edifactModel.getDelimiters().getComponent(), this.edifactModel.getDelimiters().getEscape());
            this.assertComponentsOK(expectedField, fieldIndex, segmentCode, expectedComponents, currentFieldComponents);
            for (int i = 0; i < currentFieldComponents.length; ++i) {
                String componentMessageVal = currentFieldComponents[i];
                Component expectedComponent = expectedComponents.get(i);
                this.mapComponent(componentMessageVal, expectedComponent, fieldIndex, i, segmentCode, expectedField.getXmltag());
            }
            this.endElement(expectedField.getXmltag(), true);
        } else {
            if (expectedField.isRequired() && fieldMessageVal.length() == 0) {
                throw new EDIParseException(this.edifactModel.getEdimap(), "Segment [" + segmentCode + "], field " + (fieldIndex + 1) + " (" + expectedField.getXmltag() + ") expected to contain a value.  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".");
            }
            this.contentHandler.characters(fieldMessageVal.toCharArray(), 0, fieldMessageVal.length());
            this.endElement(expectedField.getXmltag(), false);
        }
    }

    private void mapComponent(String componentMessageVal, Component expectedComponent, int fieldIndex, int componentIndex, String segmentCode, String field) throws SAXException {
        List<SubComponent> expectedSubComponents = expectedComponent.getSubComponent();
        this.startElement(expectedComponent.getXmltag(), true);
        if (expectedSubComponents.size() != 0) {
            String[] currentComponentSubComponents = EDIUtils.split(componentMessageVal, this.edifactModel.getDelimiters().getSubComponent(), this.edifactModel.getDelimiters().getEscape());
            this.assertSubComponentsOK(expectedComponent, fieldIndex, componentIndex, segmentCode, field, expectedSubComponents, currentComponentSubComponents);
            for (int i = 0; i < currentComponentSubComponents.length; ++i) {
                if (expectedSubComponents.get(i).isRequired() && currentComponentSubComponents[i].length() == 0) {
                    throw new EDIParseException(this.edifactModel.getEdimap(), "Segment [" + segmentCode + "], field " + (fieldIndex + 1) + " (" + field + "), component " + (componentIndex + 1) + " (" + expectedComponent.getXmltag() + "), sub-component " + (i + 1) + " (" + expectedSubComponents.get(i).getXmltag() + ") expected to contain a value.  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".");
                }
                this.startElement(expectedSubComponents.get(i).getXmltag(), true);
                this.contentHandler.characters(currentComponentSubComponents[i].toCharArray(), 0, currentComponentSubComponents[i].length());
                this.endElement(expectedSubComponents.get(i).getXmltag(), false);
            }
            this.endElement(expectedComponent.getXmltag(), true);
        } else {
            if (expectedComponent.isRequired() && componentMessageVal.length() == 0) {
                throw new EDIParseException(this.edifactModel.getEdimap(), "Segment [" + segmentCode + "], field " + (fieldIndex + 1) + " (" + field + "), component " + (componentIndex + 1) + " (" + expectedComponent.getXmltag() + ") expected to contain a value.  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".");
            }
            this.contentHandler.characters(componentMessageVal.toCharArray(), 0, componentMessageVal.length());
            this.endElement(expectedComponent.getXmltag(), false);
        }
    }

    private void assertFieldsOK(String[] currentSegmentFields, Segment segment) throws EDIParseException {
        List<Field> expectedFields = segment.getFields();
        int numFieldsExpected = expectedFields.size() + 1;
        if (currentSegmentFields.length != numFieldsExpected) {
            boolean throwException = false;
            if (segment.isTruncatable()) {
                int numFieldsMissing = numFieldsExpected - currentSegmentFields.length;
                for (int i = expectedFields.size() - 1; i > expectedFields.size() - numFieldsMissing - 1; --i) {
                    if (!expectedFields.get(i).isRequired()) continue;
                    throwException = true;
                    break;
                }
            } else {
                throwException = true;
            }
            if (throwException) {
                throw new EDIParseException(this.edifactModel.getEdimap(), "Segment [" + segment.getSegcode() + "] expected to contain " + (numFieldsExpected - 1) + " fields.  Actually contains " + (currentSegmentFields.length - 1) + " fields (not including segment code).  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".");
            }
        }
        for (int i = 1; i < currentSegmentFields.length; ++i) {
            Field field = expectedFields.get(i - 1);
            if (field.getComponent().size() != 0 || currentSegmentFields[i].equals("")) continue;
            this.validateValueNode(field, currentSegmentFields[i]);
        }
    }

    private void assertComponentsOK(Field expectedField, int fieldIndex, String segmentCode, List<Component> expectedComponents, String[] currentFieldComponents) throws EDIParseException {
        if (currentFieldComponents.length != expectedComponents.size()) {
            boolean throwException = false;
            if (expectedField.isTruncatable()) {
                if (currentFieldComponents.length == 0) {
                    return;
                }
                int numComponentsMissing = expectedComponents.size() - currentFieldComponents.length;
                for (int i = expectedComponents.size() - 1; i > expectedComponents.size() - numComponentsMissing - 1; --i) {
                    if (!expectedComponents.get(i).isRequired()) continue;
                    throwException = true;
                    break;
                }
            } else {
                throwException = true;
            }
            if (throwException) {
                throw new EDIParseException(this.edifactModel.getEdimap(), "Segment [" + segmentCode + "], field " + (fieldIndex + 1) + " (" + expectedField.getXmltag() + ") expected to contain " + expectedComponents.size() + " components.  Actually contains " + currentFieldComponents.length + " components.  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".");
            }
        }
        for (int i = 0; i < currentFieldComponents.length; ++i) {
            Component component = expectedComponents.get(i);
            if (component.getSubComponent().size() != 0 || currentFieldComponents[i].equals("")) continue;
            this.validateValueNode(component, currentFieldComponents[i]);
        }
    }

    private void assertSubComponentsOK(Component expectedComponent, int fieldIndex, int componentIndex, String segmentCode, String field, List<SubComponent> expectedSubComponents, String[] currentComponentSubComponents) throws EDIParseException {
        if (currentComponentSubComponents.length != expectedSubComponents.size()) {
            boolean throwException = false;
            if (expectedComponent.isTruncatable()) {
                if (currentComponentSubComponents.length == 0) {
                    return;
                }
                int numSubComponentsMissing = expectedSubComponents.size() - currentComponentSubComponents.length;
                for (int i = expectedSubComponents.size() - 1; i > expectedSubComponents.size() - numSubComponentsMissing - 1; --i) {
                    if (!expectedSubComponents.get(i).isRequired()) continue;
                    throwException = true;
                    break;
                }
            } else {
                throwException = true;
            }
            if (throwException) {
                throw new EDIParseException(this.edifactModel.getEdimap(), "Segment [" + segmentCode + "], field " + (fieldIndex + 1) + " (" + field + "), component " + (componentIndex + 1) + " (" + expectedComponent.getXmltag() + ") expected to contain " + expectedSubComponents.size() + " sub-components.  Actually contains " + currentComponentSubComponents.length + " sub-components.  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".");
            }
        }
        for (int i = 0; i < currentComponentSubComponents.length; ++i) {
            SubComponent subComponent = expectedSubComponents.get(i);
            if (currentComponentSubComponents[i].equals("")) continue;
            this.validateValueNode(subComponent, currentComponentSubComponents[i]);
        }
    }

    private void validateValueNode(ValueNode valueNode, String value) throws EDIParseException {
        try {
            if (!this.getFeature(VALIDATE)) {
                return;
            }
        }
        catch (SAXNotRecognizedException e) {
            throw new EDIParseException("Unable to decide whether to validate value-node or not.", e);
        }
        catch (SAXNotSupportedException e) {
            throw new EDIParseException("Unable to decide whether to validate value-node or not.", e);
        }
        if (valueNode.getType() != null && !valueNode.getType().equals("") && !valueNode.isValidForType(value)) {
            throw new EDIParseException(this.edifactModel.getEdimap(), "Validation of expected type [" + valueNode.getType() + "] failed for value [" + value + "]. Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".");
        }
        if (valueNode.getMinLength() != null && value.length() < valueNode.getMinLength()) {
            throw new EDIParseException(this.edifactModel.getEdimap(), "Value [" + value + "] should have a length greater than [" + valueNode.getMinLength() + "]. Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".");
        }
        if (valueNode.getMaxLength() != null && value.length() > valueNode.getMaxLength()) {
            throw new EDIParseException(this.edifactModel.getEdimap(), "Value [" + value + "] exceeds allowed maximum length of [" + valueNode.getMaxLength() + "]. Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".");
        }
    }

    private void startElement(String elementName, boolean indent) throws SAXException {
        if (indent) {
            this.indent();
        }
        this.contentHandler.startElement(null, elementName, "", EMPTY_ATTRIBS);
        ++this.depth;
    }

    private void endElement(String elementName, boolean indent) throws SAXException {
        --this.depth;
        if (indent) {
            this.indent();
        }
        this.contentHandler.endElement(null, elementName, "");
    }

    private void indent() throws SAXException {
        this.contentHandler.characters(indentChars, 0, this.depth + 1);
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException("Operation not supports by this reader.");
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.getFeatures().get(name);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.getFeatures().put(name, value);
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setDTDHandler(DTDHandler arg0) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setEntityResolver(EntityResolver arg0) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public void setErrorHandler(ErrorHandler arg0) {
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    private Map<String, Boolean> getFeatures() {
        if (this.features == null) {
            this.initializeFeatures();
        }
        return this.features;
    }

    private void initializeFeatures() {
        this.features = new HashMap<String, Boolean>();
        this.features.put(VALIDATE, false);
    }
}

