/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.instrumentation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.nd4j.linalg.api.buffer.DataBuffer;

public class DataBufferLogEntry
implements Serializable {
    protected long length;
    protected Collection<String> references;
    protected String dataType;
    protected StackTraceElement[] stackTraceElements;
    protected long timestamp;
    protected String status = "created";

    public DataBufferLogEntry() {
    }

    public DataBufferLogEntry(DataBuffer buffer, String status) {
        this.length = buffer.length();
        this.dataType = buffer.dataType() == DataBuffer.Type.DOUBLE ? "double" : "float";
        this.stackTraceElements = Thread.currentThread().getStackTrace();
        this.references = buffer.references();
        this.timestamp = System.currentTimeMillis();
        this.status = status;
    }

    public DataBufferLogEntry(DataBuffer buffer) {
        this(buffer, "created");
    }

    public String toString() {
        return "DataBufferLogEntry{length=" + this.length + ", references=" + this.references + ", dataType='" + this.dataType + '\'' + ", stackTraceElements=" + Arrays.toString(this.stackTraceElements) + '}';
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataBufferLogEntry)) {
            return false;
        }
        DataBufferLogEntry that = (DataBufferLogEntry)o;
        if (this.length != that.length) {
            return false;
        }
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.dataType != null ? !this.dataType.equals(that.dataType) : that.dataType != null) {
            return false;
        }
        if (this.references != null ? !this.references.equals(that.references) : that.references != null) {
            return false;
        }
        if (!Arrays.equals(this.stackTraceElements, that.stackTraceElements)) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        int result = (int)(this.length ^ this.length >>> 32);
        result = 31 * result + (this.references != null ? this.references.hashCode() : 0);
        result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
        result = 31 * result + (this.stackTraceElements != null ? Arrays.hashCode(this.stackTraceElements) : 0);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        return result;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long length() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public Collection<String> getReferences() {
        return this.references;
    }

    public void setReferences(Collection<String> references) {
        this.references = references;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public StackTraceElement[] getStackTraceElements() {
        return this.stackTraceElements;
    }

    public void setStackTraceElements(StackTraceElement[] stackTraceElements) {
        this.stackTraceElements = stackTraceElements;
    }
}

