/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.accum.Sum;
import org.nd4j.linalg.api.shape.Shape;

public class Mean
extends Sum {
    public Mean(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        super(sameDiff, i_v, dimensions);
    }

    public Mean(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    public Mean() {
    }

    public Mean(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public Mean(INDArray x, INDArray y, long n) {
        super(x, y, n);
    }

    public Mean(INDArray x) {
        super(x);
    }

    public Mean(INDArray x, INDArray y) {
        super(x, y);
    }

    public Mean(INDArray x, INDArray y, INDArray z) {
        super(x, y, z, x.lengthLong());
    }

    @Override
    public int opNum() {
        return 0;
    }

    @Override
    public String opName() {
        return "mean";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v1) {
        int n = this.f().getReductionLength(this);
        int rank = Shape.rankFromShape(this.arg().getShape());
        SDVariable broadcastableGrad = this.f().reductionBroadcastableWithOrigShape(rank, this.dimensions, i_v1.get(0));
        SDVariable ret = this.sameDiff.onesLike(this.arg()).div(n);
        ret = ret.mul(broadcastableGrad);
        return Arrays.asList(ret);
    }

    @Override
    public String onnxName() {
        return "ReduceMean";
    }

    @Override
    public String tensorflowName() {
        return "Mean";
    }
}

