/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.accum.Variance;
import org.nd4j.linalg.api.shape.Shape;

public class StandardDeviation
extends Variance {
    public StandardDeviation(SameDiff sameDiff, SDVariable i_v, int[] dimensions, boolean biasCorrected) {
        super(sameDiff, i_v, dimensions, biasCorrected);
    }

    public StandardDeviation(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions, boolean biasCorrected) {
        super(sameDiff, i_v, i_v2, dimensions, biasCorrected);
    }

    public StandardDeviation(INDArray x, boolean biasCorrected) {
        super(x, biasCorrected);
    }

    public StandardDeviation(INDArray x, INDArray y, INDArray z, long n, boolean biasCorrected) {
        super(x, y, z, n, biasCorrected);
    }

    public StandardDeviation() {
    }

    public StandardDeviation(INDArray x, INDArray y, long n) {
        super(x, y, n);
    }

    public StandardDeviation(INDArray x) {
        super(x);
    }

    public StandardDeviation(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public int opNum() {
        return 1;
    }

    @Override
    public String opName() {
        return "std";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v1) {
        int origRank = Shape.rankFromShape(this.arg().getShape());
        int n = this.f().getReductionLength(this);
        SDVariable broadcastableStdevOut = this.f().reductionBroadcastableWithOrigShape(origRank, this.dimensions, this.outputVariables()[0]);
        SDVariable broadcastableMean = this.f().reductionBroadcastableWithOrigShape(origRank, this.dimensions, this.f().mean(this.arg(), this.dimensions));
        SDVariable diff = this.arg().sub(broadcastableMean);
        SDVariable dOutdIn = diff.div(broadcastableStdevOut);
        dOutdIn = this.biasCorrected ? dOutdIn.div(n - 1) : dOutdIn.div(n);
        SDVariable broadcastableGrad = this.f().reductionBroadcastableWithOrigShape(origRank, this.dimensions, i_v1.get(0));
        SDVariable dLdIn = dOutdIn.mul(broadcastableGrad);
        return Arrays.asList(dLdIn);
    }
}

