/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.HashMap;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.onnx.OnnxGraphMapper;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Gather
extends DynamicCustomOp {
    protected int[] broadcast;
    protected int axis = 0;

    public Gather(SameDiff sameDiff, SDVariable input, int axis, int[] broadcast, boolean inPlace) {
        super(null, sameDiff, new SDVariable[]{input}, inPlace);
        this.addIArgument(axis);
        this.addIArgument(broadcast);
        this.axis = axis;
        this.broadcast = broadcast;
    }

    public Gather(SameDiff sameDiff, SDVariable input, SDVariable indices, int axis, boolean inPlace) {
        super(null, sameDiff, new SDVariable[]{input, indices}, inPlace);
        this.addIArgument(axis);
        this.axis = axis;
    }

    @Override
    public String onnxName() {
        return "Gather";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"Gather", "GatherV2"};
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.getInstance().initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
        OnnxGraphMapper.getInstance().initFunctionFromProperties(node.getOpType(), this, attributesForNode, node, graph);
    }

    @Override
    public void resolvePropertiesFromSameDiffBeforeExecution() {
        super.resolvePropertiesFromSameDiffBeforeExecution();
        if (this.broadcast != null && this.numInputArguments() < 2) {
            if (this.numInputArguments() == 0) {
                this.addInputArgument(this.args()[0].getArr(), Nd4j.create(ArrayUtil.toFloats((int[])this.broadcast)).reshape(this.broadcast.length));
            } else if (this.numInputArguments() == 1) {
                this.addInputArgument(Nd4j.create(ArrayUtil.toFloats((int[])this.broadcast)));
            }
        }
        if (this.numIArguments() < 1) {
            this.addIArgument(this.axis);
        }
        if (this.numOutputArguments() < this.getDescriptor().getNumOutputs()) {
            SDVariable[] outputs = this.outputVariables();
            for (int i = 0; i < outputs.length; ++i) {
                INDArray output = outputs[i].getArr();
                this.addOutputArgument(output);
            }
        }
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping broadcast = PropertyMapping.builder().onnxAttrName("broadcast").tfInputPosition(1).propertyNames(new String[]{"broadcast"}).build();
        map.put("broadcast", broadcast);
        ret.put(this.tensorflowNames()[0], map);
        ret.put(this.onnxName(), map);
        HashMap<String, PropertyMapping> map2 = new HashMap<String, PropertyMapping>();
        PropertyMapping broadcast2 = PropertyMapping.builder().tfInputPosition(1).propertyNames(new String[]{"broadcast"}).build();
        map2.put("broadcast", broadcast2);
        PropertyMapping axis2 = PropertyMapping.builder().tfInputPosition(2).propertyNames(new String[]{"axis"}).build();
        map2.put("axis", axis2);
        ret.put("GatherV2", map2);
        return ret;
    }

    @Override
    public String opName() {
        return "gather";
    }

    public Gather() {
    }
}

