/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.shape.Shape;

public abstract class BaseDynamicTransformOp
extends DynamicCustomOp {
    public BaseDynamicTransformOp() {
    }

    public BaseDynamicTransformOp(SameDiff sameDiff, SDVariable[] args, boolean inPlace) {
        super(null, sameDiff, args, inPlace);
    }

    public BaseDynamicTransformOp(INDArray[] inputs, INDArray[] outputs) {
        super(null, inputs, outputs);
    }

    @Override
    public List<int[]> calculateOutputShape() {
        SDVariable[] args = this.args();
        if (args.length < 2) {
            if (args[0] == null || args[0].getShape() == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(new int[][]{args[0].getShape()});
        }
        int[] firstArgShape = args[0].getShape();
        int[] secondArgShape = args[1].getShape();
        if (args[0] == null || args[0].getShape() == null) {
            return Collections.emptyList();
        }
        if (args[1] == null || args[1].getShape() == null) {
            return Collections.emptyList();
        }
        if (Arrays.equals(firstArgShape, secondArgShape)) {
            return Collections.singletonList(firstArgShape);
        }
        Shape.assertBroadcastable(firstArgShape, secondArgShape);
        int[] outShape = Shape.broadcastOutputShape(firstArgShape, secondArgShape);
        return Collections.singletonList(outShape);
    }
}

