/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;

public class GaussianDistribution
extends BaseRandomOp {
    private double mean;
    private double stddev;

    public GaussianDistribution() {
    }

    public GaussianDistribution(@NonNull INDArray z, double mean, double stddev) {
        if (z == null) {
            throw new NullPointerException("z");
        }
        this.init(z, z, z, z.lengthLong());
        this.mean = mean;
        this.stddev = stddev;
        this.extraArgs = new Object[]{this.mean, this.stddev};
    }

    public GaussianDistribution(@NonNull INDArray z, @NonNull INDArray means, double stddev) {
        if (z == null) {
            throw new NullPointerException("z");
        }
        if (means == null) {
            throw new NullPointerException("means");
        }
        if (z.lengthLong() != means.lengthLong()) {
            throw new IllegalStateException("Result length should be equal to provided Means length");
        }
        if (means.elementWiseStride() < 1) {
            throw new IllegalStateException("Means array can't have negative EWS");
        }
        this.init(z, means, z, z.lengthLong());
        this.mean = 0.0;
        this.stddev = stddev;
        this.extraArgs = new Object[]{this.mean, this.stddev};
    }

    public GaussianDistribution(@NonNull INDArray z) {
        this(z, 0.0, 1.0);
        if (z == null) {
            throw new NullPointerException("z");
        }
    }

    public GaussianDistribution(@NonNull INDArray z, double stddev) {
        this(z, 0.0, stddev);
        if (z == null) {
            throw new NullPointerException("z");
        }
    }

    @Override
    public int opNum() {
        return 6;
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("mean", this.mean);
        ret.put("stddev", this.stddev);
        return ret;
    }

    @Override
    public String opName() {
        return "distribution_gaussian";
    }

    @Override
    public boolean isExecSpecial() {
        return true;
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return null;
    }
}

