/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class SpaceToDepth
extends DynamicCustomOp {
    private String dataFormat;
    private int blockSize;

    public SpaceToDepth() {
    }

    public SpaceToDepth(SameDiff sameDiff, SDVariable[] args, int blockSize, String dataFormat) {
        super(null, sameDiff, args, false);
        this.blockSize = blockSize;
        this.dataFormat = dataFormat;
        boolean isNHWC = dataFormat.equals("NHWC");
        this.addIArgument(blockSize, isNHWC ? 1 : 0);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable gradient = i_v.get(0);
        SDVariable ret = this.sameDiff.depthToSpace(gradient, this.blockSize, this.dataFormat);
        return Arrays.asList(ret);
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.getInstance().initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        boolean isNHWC = this.dataFormat == null ? true : this.dataFormat.equals("NHWC");
        this.addIArgument(this.blockSize, isNHWC ? 1 : 0);
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        LinkedHashMap<String, PropertyMapping> attrs = new LinkedHashMap<String, PropertyMapping>();
        PropertyMapping blockSize = PropertyMapping.builder().tfAttrName("block_size").propertyNames(new String[]{"blockSize"}).build();
        attrs.put("blockSize", blockSize);
        PropertyMapping dataFormatMapping = PropertyMapping.builder().tfAttrName("data_format").propertyNames(new String[]{"dataFormat"}).build();
        attrs.put("dataFormat", dataFormatMapping);
        ret.put(this.tensorflowName(), attrs);
        return ret;
    }

    @Override
    public String opName() {
        return "space_to_depth";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"SpaceToDepth"};
    }

    @Override
    public String tensorflowName() {
        return "SpaceToDepth";
    }
}

