/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing.conditions;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.Condition;

public abstract class BaseCondition
implements Condition {
    protected Number value;
    protected IComplexNumber complexNumber;

    public BaseCondition(Number value) {
        this.value = value;
        this.complexNumber = Nd4j.createComplexNumber(value, 0);
    }

    @Override
    public double epsThreshold() {
        return Nd4j.EPS_THRESHOLD;
    }

    @Override
    public double getValue() {
        return this.value.doubleValue();
    }

    public BaseCondition(IComplexNumber complexNumber) {
        this.complexNumber = complexNumber;
        this.value = complexNumber.absoluteValue();
    }
}

